"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const utils = require("../lib/utils");
describe('i18n utils', () => {
    describe('locale from headers', () => {
        it('should return base if no headers found', () => {
            const result = utils.getLocaleFromHeader();
            (0, chai_1.expect)(result).to.eq('base');
        });
        it('should return the language from the header', () => {
            let result = utils.getLocaleFromHeader({ 'accept-language': 'en-US' });
            (0, chai_1.expect)(result).to.eq('en-US');
            result = utils.getLocaleFromHeader({ 'accept-language': 'en' });
            (0, chai_1.expect)(result).to.eq('en-US');
        });
        it('should return the base of no locale match found', () => {
            const result = utils.getLocaleFromHeader({ 'accept-language': 'nl-NL' });
            (0, chai_1.expect)(result).to.eq('base');
        });
    });
});
//# sourceMappingURL=utils-test.js.map