"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const path = require("path");
const sinon = require("sinon");
const et = require("../lib/transformers/enum-transformer");
const transformerUtils = require("../lib/transformers/transformer-utils");
const test_helper_1 = require("./test-helper");
const FIXTURE_ENUM = path.resolve('./test/fixtures/test-app/lib/enums/saleable-product-line-origin.ts');
const FIXTURE_ENUM_INDEX = path.resolve('./test/fixtures/test-app/lib/enums/_index.ts');
const FIXTURE_NODE = path.resolve('./test/fixtures/test-app/lib/nodes/address.ts');
describe('Enum Transformer', () => {
    let writeLiteralsStub;
    beforeEach(() => {
        writeLiteralsStub = sinon.stub(transformerUtils, 'writeStringLiteralsToBase');
    });
    afterEach(() => {
        writeLiteralsStub.restore();
    });
    describe('execution', () => {
        it('should exclude node files', () => {
            (0, test_helper_1.transpileFixture)(FIXTURE_NODE, [et.enumTransformer]);
            (0, chai_1.expect)(writeLiteralsStub.getCalls().length).to.be.equal(0);
        });
        it('should exclude index files inside pages', () => {
            (0, test_helper_1.transpileFixture)(FIXTURE_ENUM_INDEX, [et.enumTransformer]);
            (0, chai_1.expect)(writeLiteralsStub.getCalls().length).to.be.equal(0);
        });
    });
    describe('enums', () => {
        it('should extract enum members', () => {
            (0, test_helper_1.transpileFixture)(FIXTURE_ENUM, [et.enumTransformer]);
            (0, chai_1.expect)(writeLiteralsStub.getCalls().length).to.be.equal(1);
            const call = writeLiteralsStub.getCall(0);
            const dictionary = call.args[0];
            (0, chai_1.expect)(dictionary).to.be.instanceOf(Object);
            (0, chai_1.expect)(Object.keys(dictionary).length).to.eq(4);
            (0, chai_1.expect)(dictionary['@sage/test-i18n-app/enums__saleable_product_line_origin__manual']).to.be.eq('Manual');
            (0, chai_1.expect)(dictionary['@sage/test-i18n-app/enums__saleable_product_line_origin__operations']).to.be.eq('Operations');
            (0, chai_1.expect)(dictionary['@sage/test-i18n-app/enums__saleable_product_line_origin__productRequirements']).to.be.eq('Product requirements');
            (0, chai_1.expect)(dictionary['@sage/test-i18n-app/enums__saleable_product_line_origin__budgetLines']).to.be.eq('Budget lines');
        });
    });
});
//# sourceMappingURL=enum-transformer-test.js.map