"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const path = require("path");
const sinon = require("sinon");
const dt = require("../lib/transformers/decorator-transformer");
const transformerUtils = require("../lib/transformers/transformer-utils");
const test_helper_1 = require("./test-helper");
const FIXTURE_PAGE = path.resolve('./test/fixtures/test-app/lib/pages/action-buttons.ts');
const FIXTURE_NODE_INDEX = path.resolve('./test/fixtures/test-app/lib/nodes/_index.ts');
const FIXTURE_NODE = path.resolve('./test/fixtures/test-app/lib/nodes/address.ts');
const FIXTURE_PAGE_INDEX = path.resolve('./test/fixtures/test-app/lib/pages/index.ts');
describe('Decorator Transformer', () => {
    let visitorStub;
    let writeLiteralsStub;
    beforeEach(() => {
        writeLiteralsStub = sinon.stub(transformerUtils, 'writeStringLiteralsToBase');
    });
    afterEach(() => {
        writeLiteralsStub.restore();
    });
    describe('execution', () => {
        beforeEach(() => {
            visitorStub = sinon.stub(dt, 'visitor');
        });
        afterEach(() => {
            visitorStub.restore();
        });
        it('should exclude node files', () => {
            (0, test_helper_1.transpileFixture)(FIXTURE_NODE_INDEX, [dt.decoratorTransformer]);
            (0, test_helper_1.transpileFixture)(FIXTURE_NODE, [dt.decoratorTransformer]);
            (0, chai_1.expect)(visitorStub.getCalls().length).to.be.equal(0);
        });
        it('should exclude index files inside pages', () => {
            (0, test_helper_1.transpileFixture)(FIXTURE_PAGE_INDEX, [dt.decoratorTransformer]);
            (0, chai_1.expect)(visitorStub.getCalls().length).to.be.equal(0);
        });
    });
    describe('pages', () => {
        it('should wrap strings and template literals', () => {
            const result = (0, test_helper_1.transpileFixture)(FIXTURE_PAGE, [dt.decoratorTransformer]);
            (0, chai_1.expect)(result).to.contain('ui.localize("@sage/test-i18n-app/pages__action_buttons____title", "Action Buttons")');
            (0, chai_1.expect)(result).to.contain('ui.localize("@sage/test-i18n-app/pages__action_buttons__businessAction1____title", "Business action 1")');
            (0, chai_1.expect)(result).to.contain('ui.localize("@sage/test-i18n-app/pages__action_buttons__businessAction2____title", "Business action 2")');
            (0, chai_1.expect)(result).to.contain('ui.localize("@sage/test-i18n-app/pages__action_buttons__mainSection____title", "About this page")');
            (0, chai_1.expect)(result).to.contain('ui.localize("@sage/test-i18n-app/pages__action_buttons__mainBlock____title", "")');
            (0, chai_1.expect)(result).to.contain('ui.localize("@sage/test-i18n-app/pages__action_buttons__resultField____title", "Selected action")');
            (0, chai_1.expect)(result).to.contain('ui.localize("@sage/test-i18n-app/pages__action_buttons__resultField____helperText", "I am helping here")');
            (0, chai_1.expect)(result).to.contain('ui.localize("@sage/test-i18n-app/pages__action_buttons__controlSection____title", "Controlling Buttons")');
            (0, chai_1.expect)(result).to.contain('ui.localize("@sage/test-i18n-app/pages__action_buttons__controlBlock____title", "")');
            (0, chai_1.expect)(result).to.contain('ui.localize("@sage/test-i18n-app/pages__action_buttons__disableBusinessAction1____title", "Toggle Business Action 1 disabled")');
            (0, chai_1.expect)(result).to.contain('ui.localize("@sage/test-i18n-app/pages__action_buttons__hideBusinessAction2____title", "Toggle Business Action 1 hidden")');
            (0, chai_1.expect)(result).to.contain('ui.localize("@sage/test-i18n-app/pages__action_buttons__disableSaveCrudAction____title", "Toggle Save CRUD action disabled")');
        });
        it('should not remove excluded properties', () => {
            const result = (0, test_helper_1.transpileFixture)(FIXTURE_PAGE, [dt.decoratorTransformer]);
            (0, chai_1.expect)(result).to.contain("authorizationCode: 'ACTINBTNS',");
        });
    });
});
//# sourceMappingURL=decorator-transformer-test.js.map