// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/index.d.ts
declare module '@sage/xtrem-i18n/index' {
	export * from '@sage/xtrem-i18n/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/utils.d.ts
declare module '@sage/xtrem-i18n/lib/utils' {
	/// <reference types="node" />
	import { Dict, LocalizeLocale } from '@sage/xtrem-shared';
	import { IncomingHttpHeaders } from 'http';
	import * as ts from 'typescript';
	/**
	 * Gets the name of the current package
	 * @param dir the starting directory
	 * @returns the name of the package (closest ancestor)
	 */
	export function getPackageNameAndRoot(start: string): {
	    name: string;
	    root: string;
	};
	/**
	 * Gets the base name of a file
	 * @param file Typescript source file
	 * @returns base name of the given file without any extension
	 */
	export function getFileName(file: ts.SourceFile): string;
	/**
	 * Gets the directory a file belongs to
	 * @param file Typescript source file
	 * @param relativeToLib Should we get directory relative to the lib folder in the path
	 *                      or do we get that last directory in the path. Default to false
	 * @returns name of th directory the given file belongs to
	 */
	export function getDirName(file: ts.SourceFile, relativeToLib?: boolean): string;
	export const getLocaleFromHeader: (headers?: IncomingHttpHeaders) => LocalizeLocale;
	export const menuItemIdToStringKey: (menuItemId: string) => string;
	export const artifactReferenceToTitleStringKey: (artifactReference: string, artifactType: 'stickers' | 'pages') => string;
	export const enumNameToStringKey: (enumName: string, memberName: string) => string;
	export const parseObjectLiteralToObject: (objectLiteral: ts.ObjectLiteralExpression) => Dict<any>;
	export function saveAsJson(filename: string, obj: object): void;
	export function isNodeDecorator(node: ts.Node): node is ts.Decorator;
	export function getCrudBulkMutationNames(filename: string, node: ts.Decorator): string[];
	//# sourceMappingURL=utils.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/resolver.d.ts
declare module '@sage/xtrem-i18n/lib/resolver' {
	import { Dict, LocalizeLocale } from '@sage/xtrem-shared';
	export interface LocalizedLiteral {
	    key: string;
	    content: string;
	}
	export function getKey(param: {
	    isExtension?: boolean;
	    packageName: string;
	    nodeName: string;
	    operation?: {
	        kind: string;
	        name: string;
	    };
	}): string;
	export function resetDictionary(): void;
	export function getLocaleFromString(stringLocale?: string): LocalizeLocale;
	/**
	 * Reads all i18n JSON files of the current Etna application and puts them to the memory.
	 * */
	export function initializeLocalizationResolver(loadedPackages: {
	    dir: string;
	    name: string;
	}[], dir: string): void;
	export function addBundleLocalizationKeys(bundleStrings: Dict<Dict<string>>): void;
	/**
	 * Resolves a single key to a string literal
	 *
	 * @param key key to lookup, requires exact match
	 * @param locale optional, if not provided it will use f-stream's context
	 */
	export function getLiteral(key: string, locale: LocalizeLocale): LocalizedLiteral;
	/**
	 * Resolves a set of to a string literals
	 *
	 * @param keyStartsWith used to match
	 * @param locale optional, if not provided it will use f-stream's context
	 */
	export function getLiterals(keyStartsWith: string, locale: LocalizeLocale): LocalizedLiteral[];
	/**
	 * Resolves a set of to a string literals
	 *
	 * @param keyStartsWith used to match
	 * @param locale locale used to collect lirarals
	 * @param literals array to push literals
	 */
	export function appendLiterals(keyStartsWith: string, locale: LocalizeLocale, literals: LocalizedLiteral[]): LocalizedLiteral[];
	//# sourceMappingURL=resolver.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/localize.d.ts
declare module '@sage/xtrem-i18n/lib/localize' {
	import { LocalizeFunction, LocalizeLocale } from '@sage/xtrem-shared';
	/**
	 * Localize a message for the user.
	 *
	 * @param key The key which will be extracted to the translation files, must be unique in the package
	 * @param template The template value which will be translated and proof-read
	 * @param data Data to be used to populate the translated messages
	 */
	export const localizedText: LocalizeFunction;
	export function localizeEnumMember(enumName: string, memberName: string, locale?: LocalizeLocale): string;
	export const localize: LocalizeFunction;
	//# sourceMappingURL=localize.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/index.d.ts
declare module '@sage/xtrem-i18n/lib/index' {
	export * from '@sage/xtrem-i18n/lib/localize';
	export * from '@sage/xtrem-i18n/lib/resolver';
	export * from '@sage/xtrem-i18n/lib/transformers/index';
	export { artifactReferenceToTitleStringKey, enumNameToStringKey, getLocaleFromHeader, getPackageNameAndRoot, menuItemIdToStringKey, } from '@sage/xtrem-i18n/lib/utils';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/transformers/transformer-utils.d.ts
declare module '@sage/xtrem-i18n/lib/transformers/transformer-utils' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	export const literalsCache: Dict<any>;
	/**
	 * Turn nested bind property reference object to dot-notion reference. For example, it converts `{this:{is:{a:{nested:{bind:true}}}}}`
	 * to `this__is__a__nested__bind`.
	 * @param bind string or deep bind object
	 * @returns dot notion deep reference string
	 */
	export const convertDeepBindToPath: (bind?: any) => string | null;
	/**
	 * Creates a dictionary key
	 * @param prefix prefix for the generated key
	 * @param key translation key
	 * @returns dictionary key
	 */
	export const createDictionaryKey: (prefix: string, key: string, decoratorContext?: Dict<any>) => string;
	/**
	 * Determines whether the given file is a page or a sticker
	 * @param file
	 * @returns true if file is a page or a sticker
	 */
	export function isClientArtifactFile(file: ts.SourceFile): boolean;
	/**
	 * Determines whether the given file is a node or node-extension
	 * @param file
	 * @returns true if file is a node or node-extension
	 */
	export function isNodeLikeArtifactFile(file: ts.SourceFile): boolean;
	export function isNodeArtifactFile(file: ts.SourceFile): boolean;
	/**
	 * Determines whether the given file is a service option
	 * @param file
	 * @returns true if file is a service option
	 */
	export function isServiceOptionFile(file: ts.SourceFile): boolean;
	/**
	 * Determines whether the given file is an activity
	 * @param file
	 * @returns true if file is an activity
	 */
	export function isActivityFile(file: ts.SourceFile): boolean;
	/**
	 * Determines whether the given file is a dataType
	 * @param file
	 * @returns true if file is an dataType
	 */
	export function isDataTypeFile(file: ts.SourceFile): boolean;
	/**
	 * Determines whether the given file is a test file
	 * @param file
	 * @returns true if file is a test file
	 */
	export function isTestFile(file: ts.SourceFile): boolean;
	/**
	 * Determines whether the given file is an enum file
	 * @param file
	 * @returns true if file is an enum file
	 */
	export function isEnumFile(file: ts.SourceFile): boolean;
	/**
	 * Returns a copy of the target without the properties received as second parameter
	 * @returns a copy of target without the given properties
	 */
	export const excludeProperties: (target: Dict<string>, properties: string[]) => Dict<string>;
	export const sortByKey: (dict: Dict<string>) => Dict<string>;
	export const getLocaleFilePath: (dir: string, locale: string, isBuild?: boolean) => string;
	export function merge(target: Dict<string>, source: Dict<string>): Dict<string>;
	export function writeStringLiteralsToBase(currentLiterals: Dict<string>, dir: string): void;
	export interface ClientArtifactUsedLiterals {
	    strings: string[];
	    enums: string[];
	}
	/**
	 * Adds dictionary entry
	 * @param key the translation key
	 * @param value the translation value
	 * @returns the newly created key
	 */
	export function addDictionaryEntry(dictionary: Dict<string>, key: string, value: string): string;
	//# sourceMappingURL=transformer-utils.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/transformers/service-option-name-extractor.d.ts
declare module '@sage/xtrem-i18n/lib/transformers/service-option-name-extractor' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	/**
	 * Top-level TS visitor
	 * @param prefix prefix for translation keys
	 */
	export const visitor: (dictionary: Dict<string>, packageName: string, dirName: string, filename: string, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
	/**
	 * This transformer is meant to be run BEFORE the 'message-transformer' and its purpose is
	 * to wrap some page/sticker decorator properties (see 'includedProperties') with a call to the 'ui.localize' function.
	 *
	 * @param ctx transformation context
	 * @returns the transformed file
	 */
	export function serviceOptionNameExtractor(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=service-option-name-extractor.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/transformers/node-property-name-extractor.d.ts
declare module '@sage/xtrem-i18n/lib/transformers/node-property-name-extractor' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	/**
	 * Top-level TS visitor
	 * @param prefix prefix for translation keys
	 */
	export const visitor: (dictionary: Dict<string>, packageName: string, dirName: string, filename: string, ctx: ts.TransformationContext, nodePrefix?: string) => (node: ts.Node) => ts.Node;
	export function getOperationDecoratorParameters(filename: string, node: ts.Decorator): any[] | undefined;
	/**
	 * This transformer is meant to be run BEFORE the 'message-transformer' and its purpose is
	 * to wrap some page/sticker decorator properties (see 'includedProperties') with a call to the 'ui.localize' function.
	 *
	 * @param ctx transformation context
	 * @returns the transformed file
	 */
	export function nodePropertyNameExtractor(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=node-property-name-extractor.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/transformers/message-transformer.d.ts
declare module '@sage/xtrem-i18n/lib/transformers/message-transformer' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	/**
	 * Typescript visitor
	 * @param ctx the transformation context
	 */
	export const visitor: (dictionary: Dict<string>, pkgName: string, fileName: string, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
	/**
	 * This transformer is meant to be run AFTER the 'decorator-transformer' for pages/stickers &
	 * for every source file of an em-core package
	 * @param ctx the transformation context
	 * @returns the transformed file
	 */
	export function messageTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	export function tsPatchMessageTransformer(): typeof messageTransformer;
	//# sourceMappingURL=message-transformer.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/transformers/merge-translation-files.d.ts
declare module '@sage/xtrem-i18n/lib/transformers/merge-translation-files' {
	export const mergeTranslationFiles: (dir: string) => void;
	//# sourceMappingURL=merge-translation-files.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/transformers/merge-translation-files-current-dir.d.ts
declare module '@sage/xtrem-i18n/lib/transformers/merge-translation-files-current-dir' {
	export {};
	//# sourceMappingURL=merge-translation-files-current-dir.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/transformers/menu-item-transformer.d.ts
declare module '@sage/xtrem-i18n/lib/transformers/menu-item-transformer' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	/**
	 * Typescript visitor
	 * @param ctx the transformation context
	 */
	export const visitor: (dictionary: Dict<string>, pkgName: string, fileName: string, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
	/**
	 * This transformer extract menu item labels for translations from `menu-items` artifacts.
	 * @param ctx the transformation context
	 * @returns the transformed file
	 */
	export function menuItemTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=menu-item-transformer.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/transformers/index.d.ts
declare module '@sage/xtrem-i18n/lib/transformers/index' {
	export { activityNameExtractor } from '@sage/xtrem-i18n/lib/transformers/activity-name-extractor';
	export { clientListTransformer } from '@sage/xtrem-i18n/lib/transformers/client-list-transformer';
	export { dataTypesNameExtractor } from '@sage/xtrem-i18n/lib/transformers/data-type-name-extractor';
	export { decoratorTransformer } from '@sage/xtrem-i18n/lib/transformers/decorator-transformer';
	export { enumTransformer } from '@sage/xtrem-i18n/lib/transformers/enum-transformer';
	export { menuItemTransformer } from '@sage/xtrem-i18n/lib/transformers/menu-item-transformer';
	export { mergeTranslationFiles } from '@sage/xtrem-i18n/lib/transformers/merge-translation-files';
	export { messageTransformer } from '@sage/xtrem-i18n/lib/transformers/message-transformer';
	export { nodePropertyNameExtractor } from '@sage/xtrem-i18n/lib/transformers/node-property-name-extractor';
	export { serviceOptionNameExtractor } from '@sage/xtrem-i18n/lib/transformers/service-option-name-extractor';
	export { ClientArtifactUsedLiterals } from '@sage/xtrem-i18n/lib/transformers/transformer-utils';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/transformers/enum-transformer.d.ts
declare module '@sage/xtrem-i18n/lib/transformers/enum-transformer' {
	import * as ts from 'typescript';
	/**
	 * This transformer is meant to be run AFTER the 'message-transformer' for pages/stickers &
	 * for every source file of a xtrem-services package
	 * @param ctx the transformation context
	 * @returns the transformed file
	 */
	export function enumTransformer(): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=enum-transformer.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/transformers/decorator-transformer.d.ts
declare module '@sage/xtrem-i18n/lib/transformers/decorator-transformer' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	/**
	 * Top-level TS visitor
	 * @param prefix prefix for translation keys
	 */
	export const visitor: (dictionary: Dict<string>, prefix: string, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
	/**
	 * This transformer is meant to be run BEFORE the 'message-transformer' and its purpose is
	 * to wrap some page/sticker decorator properties (see 'includedProperties') with a call to the 'ui.localize' function.
	 *
	 * @param ctx transformation context
	 * @returns the transformed file
	 */
	export function decoratorTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=decorator-transformer.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/transformers/data-type-name-extractor.d.ts
declare module '@sage/xtrem-i18n/lib/transformers/data-type-name-extractor' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	/**
	 * Top-level TS visitor
	 * @param prefix prefix for translation keys
	 */
	export const visitor: (dictionary: Dict<string>, packageName: string, dirName: string, file: ts.SourceFile, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
	/**
	 * This transformer extract data-types to create literals key/value for them
	 *
	 * @param ctx transformation context
	 * @returns the transformed file
	 */
	export function dataTypesNameExtractor(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=data-type-name-extractor.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/transformers/client-list-transformer.d.ts
declare module '@sage/xtrem-i18n/lib/transformers/client-list-transformer' {
	import * as ts from 'typescript';
	/**
	 * Typescript visitor
	 * @param ctx the transformation context
	 */
	export const visitor: (usedStrings: string[], usedEnums: string[], file: ts.SourceFile, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
	/**
	 * This transformer is meant to be run AFTER the 'decorator-transformer' and 'message-transformer' for pages/stickers &
	 * for every source file of an xtrem application package. For all client side artifacts it lists the strings that the
	 * page uses so the server can send the right strings to the client.
	 *
	 * @param ctx the transformation context
	 * @returns the transformed file
	 */
	export function clientListTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=client-list-transformer.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-i18n/build/lib/transformers/activity-name-extractor.d.ts
declare module '@sage/xtrem-i18n/lib/transformers/activity-name-extractor' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	/**
	 * Top-level TS visitor
	 * @param prefix prefix for translation keys
	 */
	export const visitor: (dictionary: Dict<string>, packageName: string, dirName: string, filename: string, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
	/**
	 * This transformer extract activities to create literals key/value for them
	 *
	 * @param ctx transformation context
	 * @returns the transformed file
	 */
	export function activityNameExtractor(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=activity-name-extractor.d.ts.map
}
declare module '@sage/xtrem-i18n' {
	export * from '@sage/xtrem-i18n/index';
}
