/// <reference types="node" />
import { Dict, LocalizeLocale } from '@sage/xtrem-shared';
import { IncomingHttpHeaders } from 'http';
import * as ts from 'typescript';
/**
 * Gets the name of the current package
 * @param dir the starting directory
 * @returns the name of the package (closest ancestor)
 */
export declare function getPackageNameAndRoot(start: string): {
    name: string;
    root: string;
};
/**
 * Gets the base name of a file
 * @param file Typescript source file
 * @returns base name of the given file without any extension
 */
export declare function getFileName(file: ts.SourceFile): string;
/**
 * Gets the directory a file belongs to
 * @param file Typescript source file
 * @param relativeToLib Should we get directory relative to the lib folder in the path
 *                      or do we get that last directory in the path. Default to false
 * @returns name of th directory the given file belongs to
 */
export declare function getDirName(file: ts.SourceFile, relativeToLib?: boolean): string;
export declare const getLocaleFromHeader: (headers?: IncomingHttpHeaders) => LocalizeLocale;
export declare const menuItemIdToStringKey: (menuItemId: string) => string;
export declare const artifactReferenceToTitleStringKey: (artifactReference: string, artifactType: 'stickers' | 'pages') => string;
export declare const enumNameToStringKey: (enumName: string, memberName: string) => string;
export declare const parseObjectLiteralToObject: (objectLiteral: ts.ObjectLiteralExpression) => Dict<any>;
export declare function saveAsJson(filename: string, obj: object): void;
export declare function isNodeDecorator(node: ts.Node): node is ts.Decorator;
export declare function getCrudBulkMutationNames(filename: string, node: ts.Decorator): string[];
//# sourceMappingURL=utils.d.ts.map