import * as ts from 'typescript';
/**
 * Typescript visitor
 * @param ctx the transformation context
 */
export declare const visitor: (usedStrings: string[], usedEnums: string[], file: ts.SourceFile, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
/**
 * This transformer is meant to be run AFTER the 'decorator-transformer' and 'message-transformer' for pages/stickers &
 * for every source file of an xtrem application package. For all client side artifacts it lists the strings that the
 * page uses so the server can send the right strings to the client.
 *
 * @param ctx the transformation context
 * @returns the transformed file
 */
export declare function clientListTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
//# sourceMappingURL=client-list-transformer.d.ts.map