"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateTagging = exports.concatenateStr = void 0;
function concatenateStr(variable, attribute, value) {
    const strToAdd = `${attribute}=${value}`;
    if (variable.length === 0) {
        variable = strToAdd;
    }
    else {
        variable += `&${strToAdd}`;
    }
    return variable;
}
exports.concatenateStr = concatenateStr;
const updateTagging = (objectTagging, tagging) => {
    const updated = [];
    // updating existing tag
    if (objectTagging.TagSet && tagging.TagSet) {
        for (const tag of tagging.TagSet) {
            const tagToUpdate = objectTagging.TagSet.find(tagLookup => tagLookup.Key === tag.Key);
            if (tagToUpdate) {
                if (tagToUpdate.Value !== tag.Value) {
                    tagToUpdate.Value = tag.Value;
                    updated.push(tag.Key);
                }
            }
        }
    }
    // inserting new tag
    if (tagging.TagSet) {
        if (!objectTagging.TagSet) {
            objectTagging.TagSet = [];
        }
        for (const tag of tagging.TagSet) {
            if (tag.Key && updated.indexOf(tag.Key) < 0) {
                objectTagging.TagSet.push(tag);
                updated.push(tag);
            }
        }
    }
    return updated.length > 0;
};
exports.updateTagging = updateTagging;
