import { _Object, Tagging } from "@aws-sdk/client-s3";
import { FileTimeToLive, TenantDataType } from "@sage/xtrem-deployment";
import { FileStorageWrapper } from "./FileStorageWrapper";
import { S3BodyGet, S3BodyPut } from "./utils";
import { StreamingBlobPayloadOutputTypes } from "@smithy/types";
export default class LocalWrapper implements FileStorageWrapper {
    readonly basePath: string;
    readonly app?: string;
    setUnitTestMode(_value: boolean): void;
    constructor(basePath?: string, app?: string);
    private readonly getFullPath;
    private readonly createLocalDir;
    private readonly createLocalFile;
    private readonly readLocalFile;
    private readonly listLocalFiles;
    createFile(tenantId: string, objectKey: string, description: string, byteStream: S3BodyPut, expiration: FileTimeToLive): Promise<{
        ETag: string;
    } | undefined>;
    updateExpiration(tenantId: string, objectKey: string, expiration: FileTimeToLive): Promise<void>;
    updateTagging(tenantId: string, objectKey: string, tagging: Tagging): Promise<void>;
    private readonly getFormattedTag;
    readFile(tenantId: string, objectKey: string): Promise<{
        body: StreamingBlobPayloadOutputTypes;
        tagData: {
            TagSet: any[];
        };
    } | undefined>;
    private getFormattedFiles;
    listFiles(tenantId: string, continuationToken?: string): Promise<{
        IsTruncated: boolean;
        Contents: any[];
        Prefix: string;
        Name: string;
        KeyCount: number;
    } | undefined>;
    list(tenantDataType: TenantDataType, tenantId: string, _continuationToken?: string): Promise<{
        IsTruncated: boolean;
        Contents: any[];
        Prefix: string;
        Name: string;
        KeyCount: number;
    } | undefined>;
    listExports(tenantId: string, continuationToken?: string): Promise<any>;
    listImports(tenantId: string, continuationToken?: string): Promise<any>;
    listTenants(): Promise<{
        [key: string]: _Object[];
    }>;
    private addFilesFromFolder;
    /**
     * For local implementation we just return the path of the file
     * @param tenantId
     * @param objectKey
     * @param _urlTimeToLiveInSec
     */
    generateDownloadPresignedUrl(tenantId: string, objectKey: string, _urlTimeToLiveInSec?: number, filename?: string): Promise<string>;
    /**
     * For local implementation we just return the path of the file
     * @param tenantId
     * @param contextId
     * @param urlTimeToLiveInSec
     */
    generateUploadPresignedUrl(tenantId: string, contextId: string, urlTimeToLiveInSec?: number): Promise<string>;
    /**
     * For local implementation we just return the path of the file
     * @param tenantId
     * @param contextId
     * @param urlTimeToLiveInSec
     */
    generateAttachmentUploadPresignedUrl(tenantId: string, contextId: string, urlTimeToLiveInSec?: number): Promise<string>;
    readAsyncContextResult(tenantId: string, contextId: string, contextKind: string): Promise<{
        tagData: any;
        body: S3BodyGet;
    } | void>;
    generateAttachmentDownloadPresignedUrl(tenantId: string, attachmentId: string, _urlTimeToLiveInSec?: number): Promise<string>;
}
