import { _Object, ListObjectsV2CommandOutput, PutObjectTaggingCommandOutput, S3, Tagging } from "@aws-sdk/client-s3";
import { getSignedUrl } from "@aws-sdk/s3-request-presigner";
import { FileTimeToLive, TenantDataType } from "@sage/xtrem-deployment";
import { FileStorageConfig } from "./FileStorageHandler";
import { FileStorageWrapper } from "./FileStorageWrapper";
import { S3BodyGet, S3BodyPut } from "./utils";
export default class S3Wrapper implements FileStorageWrapper {
    s3: S3;
    bucket: string;
    app?: string;
    maxKeys: number;
    signedUrlGetter: typeof getSignedUrl;
    setMaxKeys(value: number): void;
    setBucket(value: string): void;
    setUnitTestMode(_value: boolean): void;
    constructor(configFS: FileStorageConfig, logger: (message: string) => void, s3Mock?: any);
    getApp: () => string;
    getPath: (tenantId: string, objectKey: string) => string;
    createFile(tenantId: string, objectKey: string, description: string, body: S3BodyPut, expiration: FileTimeToLive): Promise<import("@aws-sdk/client-s3").PutObjectCommandOutput>;
    updateTagging(tenantId: string, objectKey: string, tagging: Tagging): Promise<PutObjectTaggingCommandOutput>;
    updateExpiration(tenantId: string, objectKey: string, expiration: FileTimeToLive): Promise<PutObjectTaggingCommandOutput>;
    readFile(tenantId: string, objectKey: string): Promise<{
        tagData: any;
        body: S3BodyGet;
    } | void>;
    list(tenantDataType: TenantDataType, tenantId: string, continuationToken?: string): Promise<ListObjectsV2CommandOutput>;
    listFiles(tenantId: string, continuationToken?: string): Promise<ListObjectsV2CommandOutput>;
    listExports(tenantId: string, continuationToken?: string): Promise<ListObjectsV2CommandOutput>;
    listImports(tenantId: string, continuationToken?: string): Promise<ListObjectsV2CommandOutput>;
    listTenants(): Promise<{
        [key: string]: _Object[];
    }>;
    private addFiles;
    generateDownloadPresignedUrl(tenantId: string, objectKey: string, urlTimeToLiveInSec?: number, filename?: string): Promise<string>;
    generateAttachmentUploadPresignedUrl(tenantId: string, contextId: string, urlTimeToLiveInSec?: number): Promise<string>;
    generateAttachmentDownloadPresignedUrl(tenantId: string, attachmentId: string, urlTimeToLiveInSec?: number, filename?: string): Promise<string>;
    generateUploadPresignedUrl(tenantId: string, contextId: string, /* expiration: FileTimeToLive,*/ urlTimeToLiveInSec?: number): Promise<string>;
    readAsyncContextResult(tenantId: string, contextId: string, contextKind: string): Promise<{
        tagData: any;
        body: S3BodyGet;
    } | void>;
    private getSanitizedTTL;
}
