import { ButtonView } from '@ckeditor/ckeditor5-ui';
import { COMMAND_INSERT_QUERY_TABLE } from '../../constants';
import { getContextObjectType } from '../utils';
const onInsertQueryTableButtonClick = (editor) => () => {
    const reportEditorConfig = editor.config.get('reportEditorConfig');
    const selection = editor.model.document.selection;
    const contextObjectType = getContextObjectType(selection.focus?.parent);
    if (!contextObjectType) {
        return;
    }
    const currentRootName = editor.model.document.selection.getFirstRange()?.start.root.rootName || 'body';
    const lookupRequest = {
        root: currentRootName,
        contextObjectType,
        onSelected: result => editor.execute(COMMAND_INSERT_QUERY_TABLE, result),
    };
    reportEditorConfig.openLookup(lookupRequest);
};
export const createInsertQueryTableButton = (editor) => {
    const buttonView = new ButtonView(editor.locale);
    buttonView.set({
        label: 'Insert Query Table',
        tooltip: true,
        withText: true,
    });
    const command = editor.commands.get(COMMAND_INSERT_QUERY_TABLE);
    buttonView.bind('isEnabled').to(command);
    // Execute the command when the dropdown item is clicked (executed).
    editor.listenTo(buttonView, 'execute', onInsertQueryTableButtonClick(editor));
    return buttonView;
};
//# sourceMappingURL=query-table-factory.js.map