import { Command } from '@ckeditor/ckeditor5-core';
import { ATTR_CONTEXT_LIST_ORDER } from '@sage/xtrem-shared';
import { getContextSortOrder } from '../../utils';
export default class QueryTableEditOrderCommand extends Command {
    execute({ orderBy }) {
        const editor = this.editor;
        const model = this.editor.model;
        editor.model.change(writer => {
            const selection = model.document.selection;
            const queryTableElement = selection.getFirstPosition()?.findAncestor('queryTable') ||
                selection.getFirstPosition()?.findAncestor('recordContext');
            if (queryTableElement) {
                writer.setAttribute(ATTR_CONTEXT_LIST_ORDER, JSON.stringify(orderBy), queryTableElement);
            }
        });
    }
    refresh() {
        this.isEnabled = getContextSortOrder(this.editor.model.document.selection.focus?.parent) !== null;
    }
}
//# sourceMappingURL=query-table-edit-order-command.js.map