import { MultiRootEditor } from '@ckeditor/ckeditor5-editor-multi-root';
import type { DocumentContextProvider } from './context-provider';
import * as React from 'react';
import { OBJECT_TYPE_GLOBAL_PROPERTIES, OBJECT_TYPE_ROOT } from './constants';
import type { LocalizeEnumFunction, LocalizeFunction, LocalizeLocale } from '@sage/xtrem-shared';
import type { ToastProps } from 'carbon-react/esm/components/toast';
export { OBJECT_TYPE_GLOBAL_PROPERTIES, OBJECT_TYPE_ROOT };
export * from './context-provider';
export * as constants from './constants';
export { InsertQueryTableCommandArgument } from './plugins/query-table/commands/insert-query-table-command';
export type PaperSize = 'letter' | 'legal' | 'tabloid' | 'ledger' | 'a0' | 'a1' | 'a2' | 'a3' | 'a4' | 'a5' | 'a6';
export type PaperOrientation = 'landscape' | 'portrait' | 'fullScreen';
export interface XtremDocumentEditorProps {
    contextProvider: DocumentContextProvider;
    /** HTML value of the footer */
    footerValue?: string;
    /** HTML value of the header */
    headerValue?: string;
    isDisabled?: boolean;
    locale: LocalizeLocale;
    localize: LocalizeFunction;
    localizeEnumMember: LocalizeEnumFunction;
    marginBottom?: number;
    marginLeft?: number;
    marginRight?: number;
    marginTop?: number;
    onBlur?: () => void;
    /** Triggered when the page body changes */
    onChange: (newValue: string) => void;
    onDisplayNotification: (content: string, type: ToastProps['variant']) => void;
    onFocus?: () => void;
    /** Triggered when the footer changes */
    onFooterChange?: (newValue: string) => void;
    /** Triggered when the header changes */
    onHeaderChange?: (newValue: string) => void;
    /** Triggered when the editor instances are loaded */
    onReady?: (editor: MultiRootEditor) => void;
    /** Orientation of the paper displayed in the editor */
    paperOrientation?: PaperOrientation;
    /** Size of the paper displayed in the editor */
    paperSize?: PaperSize;
    /** HTML value of the page body */
    value: string;
}
export declare function XtremDocumentEditor({ contextProvider, footerValue, headerValue, isDisabled, locale, localize, localizeEnumMember, marginBottom, marginLeft, marginRight, marginTop, onBlur, onChange, onDisplayNotification, onFocus, onFooterChange, onHeaderChange, onReady, paperOrientation, paperSize, value, }: XtremDocumentEditorProps): React.ReactElement;
export default XtremDocumentEditor;
//# sourceMappingURL=index.d.ts.map