import * as React from 'react';
export const useQueryTablePropertyCommand = ({ commandName, editor, defaultValue = '', }) => {
    const [value, setValue] = React.useState(defaultValue);
    const onEditorChange = React.useCallback(() => {
        if (editor) {
            const selectedTable = editor.model.document.selection.getSelectedElement();
            if (selectedTable) {
                const currentValue = selectedTable.getAttribute(commandName);
                if (currentValue !== value) {
                    setValue(currentValue || defaultValue);
                }
            }
        }
    }, [editor, commandName, value, defaultValue]);
    React.useEffect(() => {
        onEditorChange();
        editor?.model.document.on('change', onEditorChange);
        return () => {
            editor?.model.document.off('change', onEditorChange);
        };
    }, [editor, commandName, onEditorChange]);
    const onChange = React.useCallback((changeValue) => {
        setValue(changeValue);
        editor?.execute(commandName, { value: changeValue });
    }, [editor, commandName]);
    return { value, onChange };
};
//# sourceMappingURL=use-table-property-command.js.map