import type { Editor, Plugin } from '@ckeditor/ckeditor5-core';
import type { MultiRootEditor } from '@ckeditor/ckeditor5-editor-multi-root';
import type { DocumentSelection, Element, Selection } from '@ckeditor/ckeditor5-engine';
interface TableUtilsPluginType extends Plugin {
    getSelectionAffectedTableCells: (selection: Selection | DocumentSelection) => Array<Element>;
}
export type TableUtilsPluginConstructorType = new (editor: Editor) => TableUtilsPluginType;
export interface TableCellPropertyCommandProps {
    commandName: string;
    editor: MultiRootEditor | null;
    tableUtilsPluginConstructor: TableUtilsPluginConstructorType;
    defaultValue?: any;
}
export interface TableCellPropertyProps {
    commandName: string;
    editor: MultiRootEditor | null;
    tableUtilsPluginConstructor: TableUtilsPluginConstructorType;
    defaultValue?: any;
}
export declare const useQueryTableCellPropertyCommand: ({ commandName, editor, tableUtilsPluginConstructor, defaultValue, }: TableCellPropertyCommandProps) => {
    value: string;
    onChange: (value: string) => void;
};
export {};
//# sourceMappingURL=use-table-cell-property-command.d.ts.map