import * as React from 'react';
import { getSelectedPropertyDataTypeAndFormat } from '../plugins/utils';
export const usePropertyTypeAndFormat = (editor) => {
    const [propertyType, setPropertyType] = React.useState(null);
    const [propertyFormat, setPropertyFormat] = React.useState(null);
    const onEditorChange = React.useCallback(() => {
        if (editor) {
            const dataTypeAndFormat = getSelectedPropertyDataTypeAndFormat(editor);
            setPropertyType(dataTypeAndFormat?.dataType || null);
            setPropertyFormat(dataTypeAndFormat?.format || null);
        }
    }, [editor]);
    React.useEffect(() => {
        onEditorChange();
        editor?.model.document.on('change', onEditorChange);
        return () => {
            editor?.model.document.off('change', onEditorChange);
        };
    }, [editor, onEditorChange]);
    return { propertyType, propertyFormat };
};
//# sourceMappingURL=use-property-type-and-format.js.map