/* eslint-disable react/no-unstable-nested-components */
import * as React from 'react';
import { GraphQLTypes } from '@sage/xtrem-shared';
import { GridColumn, GridRow, FilterTableComponent } from '@sage/xtrem-ui-components';
import Loader from 'carbon-react/esm/components/loader';
export function FiltersComponent({ contextProvider, filters, locale, localize, localizeEnumMember, objectType, onChange, selectedItems, }) {
    const [targetNodeDetails, setTargetNodeDetails] = React.useState(null);
    const [parameters, setParameters] = React.useState(null);
    React.useEffect(() => {
        if (objectType) {
            contextProvider.getDocumentParameters().then(setParameters);
            contextProvider
                .getObjectDetails({ objectType, canParentFilter: true, canParentSort: true, contextType: 'body' })
                .then(setTargetNodeDetails);
        }
    }, [contextProvider, objectType]);
    const selectedProperties = React.useMemo(() => {
        const basicTypes = Object.values(GraphQLTypes);
        return Object.keys(selectedItems).reduce((acc, curr) => {
            if (basicTypes.includes(selectedItems[curr].data.type) ||
                selectedItems[curr].data.kind === 'ENUM') {
                acc[curr] = selectedItems[curr];
            }
            return acc;
        }, {});
    }, [selectedItems]);
    // TODO: XT-54885 localization out of scope
    const carbonLocale = () => ({});
    // TODO: XT-54885 pass node & nodeNames to component
    const nodeNames = {};
    const node = '';
    if (!targetNodeDetails || !parameters) {
        return React.createElement(Loader, null);
    }
    return (React.createElement(GridRow, { columns: 8, gutter: 16, margin: 0, verticalMargin: 0 },
        React.createElement(GridColumn, { columnSpan: 8, className: "document-editor-filter-editor" },
            React.createElement(FilterTableComponent, { carbonLocale: carbonLocale, value: filters, locale: locale, localize: localize, parameterMode: "usage", parameters: parameters, localizeEnumMember: localizeEnumMember, node: node, nodeNames: nodeNames, onChange: onChange, selectedProperties: selectedProperties }))));
}
//# sourceMappingURL=filters-component.js.map