import * as React from 'react';
import ButtonMinor from 'carbon-react/esm/components/button-minor';
import { GridColumn } from '@sage/xtrem-ui-components';
export function EditorActionButton({ commandName, editor, label, isEnabled, }) {
    const onButtonClick = React.useCallback(() => {
        editor?.execute(commandName);
    }, [editor, commandName]);
    if (!isEnabled) {
        return null;
    }
    return (React.createElement(GridColumn, { columnSpan: 2 },
        React.createElement(ButtonMinor, { fullWidth: true, onClick: onButtonClick }, label)));
}
//# sourceMappingURL=editor-action-button.js.map