import * as React from 'react';
import ButtonMinor from 'carbon-react/esm/components/button-minor';
import { Element } from '@ckeditor/ckeditor5-engine';
import { GridColumn } from '@sage/xtrem-ui-components';
import { COMMAND_EDIT_ORDER_QUERY_TABLE } from '../constants';
import Dialog from 'carbon-react/esm/components/dialog';
import Form from 'carbon-react/esm/components/form';
import Button from 'carbon-react/esm/components/button';
import { getContextObjectType, getContextSortOrder, isTableElement } from '../plugins/utils';
import { SortingComponent } from './sorting/sorting-component';
import Loader from 'carbon-react/esm/components/loader';
import { isEmpty } from 'lodash';
import { getDeepObjectDetails } from './utils';
export function EditOrderActionButton({ editor, contextProvider, localize, isEnabled, }) {
    const [isOpen, setOpen] = React.useState(false);
    const [properties, setProperties] = React.useState(null);
    const [orderBy, setOrderBy] = React.useState({});
    const [contextObjectType, setContextObjectType] = React.useState(null);
    const focusElement = editor?.model.document.selection.focus?.parent;
    const [isTable, setIsTable] = React.useState(focusElement && focusElement instanceof Element ? isTableElement(focusElement) : false);
    React.useEffect(() => {
        setProperties(null);
        if (editor && isOpen) {
            const focusedElement = editor.model.document.selection.focus?.parent;
            const objectType = getContextObjectType(focusedElement);
            setContextObjectType(objectType);
            setOrderBy(getContextSortOrder(focusedElement) || {});
            setIsTable(focusedElement && focusedElement instanceof Element ? isTableElement(focusedElement) : false);
        }
    }, [contextProvider, editor, isOpen]);
    React.useEffect(() => {
        if (editor && isEnabled && isOpen && contextObjectType) {
            const referenceIds = Object.keys(orderBy).filter(key => key.includes('.'));
            getDeepObjectDetails(contextProvider, contextObjectType, referenceIds).then(dataModel => {
                setProperties(dataModel);
            });
        }
    }, [isEnabled, isOpen, contextProvider, editor, contextObjectType, orderBy]);
    const onSaveOrder = React.useCallback(() => {
        if (editor) {
            editor.execute(COMMAND_EDIT_ORDER_QUERY_TABLE, { orderBy });
        }
        setOpen(false);
    }, [editor, orderBy]);
    if (!isEnabled) {
        return null;
    }
    return (React.createElement(React.Fragment, null,
        React.createElement(Dialog, { open: isOpen, onCancel: () => setOpen(false), title: localize('@sage/xtrem-document-editor/edit-sorting-dialog-title', 'Edit sorting'), className: "document-editor-edit-sorting-dialog", size: "extra-large" },
            React.createElement(Form, { onSubmit: (ev) => {
                    ev.preventDefault();
                }, stickyFooter: true, height: "500px", saveButton: React.createElement(Button, { buttonType: "primary", type: "submit", onClick: onSaveOrder }, localize('@sage/xtrem-document-editor/apply-button', 'Apply')) },
                isEmpty(properties) && React.createElement(Loader, null),
                !isEmpty(properties) && properties && (React.createElement(SortingComponent, { canAddNewLines: !isTable, canDrag: !isTable, canRemoveLines: !isTable, localize: localize, onChange: setOrderBy, properties: properties, propertyReadOnly: isTable, value: orderBy })))),
        React.createElement(GridColumn, { columnSpan: 2 },
            React.createElement(ButtonMinor, { fullWidth: true, onClick: () => setOpen(true), "data-testid": "document-editor-edit-sorting-button" }, localize('@sage/xtrem-document-editor/edit-sorting-button', 'Edit sorting')))));
}
//# sourceMappingURL=edit-order-action-button.js.map