import * as React from 'react';
import { useQueryTableCellPropertyCommand } from '../use-table-cell-property-command';
import { ColorPicker } from './color-picker';
export function CellColorPicker({ title, commandName, editor, isEnabled, tableUtilsPluginConstructor, }) {
    const { value, onChange } = useQueryTableCellPropertyCommand({
        commandName,
        editor,
        tableUtilsPluginConstructor,
    });
    return (React.createElement(ColorPicker, { title: title, commandName: commandName, value: value, onChange: onChange, isEnabled: isEnabled, editor: editor }));
}
//# sourceMappingURL=cell-color-picker.js.map