import * as React from 'react';
import { Select, Option } from 'carbon-react/esm/components/select';
import { GridColumn } from '@sage/xtrem-ui-components';
import { BORDER_WIDTH } from '../../constants';
export function BorderWidth({ title, commandName, value, onChange, isEnabled, editor, }) {
    const onSelectChange = React.useCallback((event) => {
        onChange(event.target.value);
    }, [onChange]);
    if (!isEnabled || !editor) {
        return null;
    }
    return (React.createElement(GridColumn, { columnSpan: 2 },
        React.createElement(Select, { name: commandName, label: title, value: value, onChange: onSelectChange }, BORDER_WIDTH.map(c => (React.createElement(Option, { key: c, value: c, text: c }))))));
}
//# sourceMappingURL=border-width-select.js.map