import React from 'react';
import { useQueryTablePropertyCommand } from '../use-table-property-command';
import { BorderStyle } from './border-style-select';
export function TableBorderStyleSelect({ title, commandName, editor, isEnabled, }) {
    const { value, onChange } = useQueryTablePropertyCommand({
        commandName,
        editor,
    });
    return (React.createElement(BorderStyle, { title: title, commandName: commandName, value: value, onChange: onChange, isEnabled: isEnabled, editor: editor }));
}
//# sourceMappingURL=table-border-style-select.js.map