import { LocalizeLocale } from '@sage/xtrem-shared';
export type TimeDiff = {
    hours?: number;
    minutes?: number;
    seconds?: number;
    millis?: number;
};
export declare class Time {
    private readonly _value;
    constructor(value: number);
    get constructorName(): string;
    get hour(): number;
    get minute(): number;
    get second(): number;
    get value(): number;
    valueOf(): string;
    toJSON(): string;
    compare(time: Time): number;
    equals(time: Time): boolean;
    isBetween(begin: Time, end: Time): boolean;
    begOfDay(): Time;
    endOfDay(): Time;
    begOfHour(): Time;
    endOfHour(): Time;
    begOfMinute(): Time;
    endOfMinute(): Time;
    toString(): string;
    format(locale?: LocalizeLocale, format?: string): string;
    secondsDiff(t: Time): number;
    addHours(hours: number): Time;
    addMinutes(minutes: number): Time;
    addSeconds(seconds: number): Time;
    add(delta: TimeDiff): Time;
    isNull(): boolean;
    static make(hour: number, minute: number, second: number): Time;
    static fromSeconds(seconds: number): Time;
    static fromJsDate(js: Date, timeZone?: string): Time;
    static now(timeZone?: string): Time;
    static parse(str: string, locale?: LocalizeLocale, format?: string): Time;
    static amDesignator(locale?: LocalizeLocale): string;
    static pmDesignator(locale?: LocalizeLocale): string;
    static isTime(obj: any): boolean;
}
export declare const make: typeof Time.make;
export declare const fromSeconds: typeof Time.fromSeconds;
export declare const fromJsDate: typeof Time.fromJsDate;
export declare const now: typeof Time.now;
export declare const parse: typeof Time.parse;
export declare const amDesignator: typeof Time.amDesignator;
export declare const pmDesignator: typeof Time.pmDesignator;
export declare const isTime: typeof Time.isTime;
//# sourceMappingURL=time.d.ts.map