"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.make = exports.isDatetimeRange = exports.parse = exports.DatetimeRange = void 0;
const datetime_1 = require("./datetime");
const range_1 = require("./range");
class DatetimeRange extends range_1.Range {
    // eslint-disable-next-line class-methods-use-this
    get constructorName() {
        return 'DatetimeRange';
    }
    get durationInMilliseconds() {
        if (this.excludedEnd instanceof datetime_1.Datetime && this.includedStart instanceof datetime_1.Datetime) {
            return this.excludedEnd.millisDiff(this.includedStart);
        }
        return Infinity;
    }
    /** @internal */
    // eslint-disable-next-line class-methods-use-this
    incrementsByRangeUnit(elm) {
        return elm.addMilliseconds(1);
    }
    /** @internal */
    // eslint-disable-next-line class-methods-use-this
    getBoundValue(elm) {
        if (!elm)
            return null;
        return elm?.value;
    }
    /** @internal */
    // eslint-disable-next-line class-methods-use-this
    getStringBoundValue(elm) {
        if (!elm)
            return '';
        return elm.toString();
    }
    // parse datetime range from UTC to Local
    static parse(str, timeZone) {
        const [start, end] = str.split(',');
        if (!end)
            throw new Error(`invalid datetime range format: ${str}.`);
        if (!start && !end)
            return new DatetimeRange(null, null);
        const excludesStart = start.length === 0 || start.startsWith('(');
        const excludesEnd = end.length === 0 || end.endsWith(')');
        const parseHalf = (s) => {
            if (!s) {
                return null;
            }
            const clean = s.replace(/"?(\d{1,4})(?:-(\d{1,2})(?:-(\d{1,2})(?:[T ](\d{1,2})(?::(\d{1,2})(?::(\d{1,2}))?)?)?)?)?([^"]*)"?/, (_all, year, month = '01', day = '01', hour = '00', minute = '00', second = '00', tail = '') => `${year.padStart(4, '0')}-${month.padStart(2, '0')}-${day.padStart(2, '0')}T${hour.padStart(2, '0')}:${minute.padStart(2, '0')}:${second.padStart(2, '0')}${tail}`);
            return datetime_1.Datetime.parse(clean, undefined, undefined, timeZone);
        };
        return new DatetimeRange(parseHalf(start && start.substring(1)), parseHalf(end && end.substring(0, end.length - 1)), excludesStart, excludesEnd);
    }
    static isDatetimeRange(obj) {
        return obj && obj.constructorName === 'DatetimeRange';
    }
    static make(start, end, excludesStart = false, excludesEnd = true) {
        return new DatetimeRange(start, end, excludesStart, excludesEnd);
    }
}
exports.DatetimeRange = DatetimeRange;
exports.parse = DatetimeRange.parse.bind(DatetimeRange);
exports.isDatetimeRange = DatetimeRange.isDatetimeRange.bind(DatetimeRange);
exports.make = DatetimeRange.make.bind(DatetimeRange);
//# sourceMappingURL=datetime-range.js.map