export type WorkflowStepIcon = 'addons' | 'bright' | 'trash-bin' | 'clock' | 'print' | 'mail' | 'megaphone' | 'accounting' | 'binocular' | 'database' | 'pencil' | 'connected' | 'hourglass';
export type WorkflowStepShape = 'oval' | 'diamond';
export interface WorkflowStepUiOptions {
    icon: WorkflowStepIcon;
    shape: WorkflowStepShape;
    color: string;
    configurationPage: string;
}
export interface WorkflowStepUiDescriptor extends WorkflowStepUiOptions {
    type: 'event' | 'action' | 'condition';
    key: string;
    title: string;
    description: string;
}
export interface WorkflowStepDescriptor {
    type: 'event' | 'action' | 'condition';
    key: string;
    title: string;
    description: string;
    startTopics?: string;
    resumeTopics?: string;
    minOutputs?: number;
    maxOutputs?: number;
    ui: WorkflowStepUiOptions;
}
export interface WorkflowStepInterface {
    descriptor: WorkflowStepDescriptor;
}
//# sourceMappingURL=workflow-step-descriptor.d.ts.map