import { Dict, WorkflowVariable } from '@sage/xtrem-shared';
import { WorkflowMockOptions } from './workflow-mock';
import { WorkflowStepDescriptor, WorkflowStepInterface } from './workflow-step-descriptor';
export interface WorkflowRunOptions {
    tenantId: string;
    userId: string;
    mocks?: WorkflowMockOptions[];
}
export interface WorkflowStartEvent<PayloadT = unknown> {
    topic: string;
    payload: PayloadT;
}
export interface WorkflowError {
    stepId: string;
    message: string;
}
export interface WorkflowResult {
    status: string;
    variables?: Dict<WorkflowVariable>;
    errors?: WorkflowError[];
}
export interface WorkflowManagerInterface {
    registerWorkflowStep(packageName: string, workflowStep: WorkflowStepInterface): void;
    getWorkflowStepDescriptors(): WorkflowStepDescriptor[];
    getWorkflowStepDescriptor(key: string): WorkflowStepDescriptor;
    getWorkflowTopics(): string[];
    run(startEvent: WorkflowStartEvent, options: WorkflowRunOptions): Promise<WorkflowResult>;
    start(): Promise<void>;
}
//# sourceMappingURL=workflow-manager-interface.d.ts.map