import { AnyValue } from '@sage/xtrem-shared';
import { NodeStorage, TypeName } from '../decorators';
import { Property } from '../properties';
import { PropertyAndValue } from '../runtime';
/**
 * `notNull(x)` is equivalent to `x!` but keeps sonar quiet
 *
 * We use it to deal with nullable properties inside functions that must be convertible to SQL
 * because the ts-to-sql converter does not (yet) support local variables inside functions.
 */
export declare const notNull: <T extends AnyValue>(x: T) => NonNullable<T>;
export declare function typeDefaultValue(type: TypeName | undefined, isNullable?: boolean, isLocalized?: boolean, storage?: NodeStorage): any;
/**
 * Returns the default value for a custom field, based on its type and isMandatory attribute.
 * We cannot use getTypeDefaultValue() for this because custom fields do not have an isNullable attribute.
 * This function only returns `null` if the field is not mandatory and the type does not have an _obvious_ default value.
 * 0 is an obvious default value for numbers but null is a more obvious default value than date.today() for non mandatory dates.
 */
export declare function customFieldTypeDefaultValue(type: TypeName | undefined, isMandatory?: boolean): any;
export declare function safeParseInt(value: unknown, propertyName?: string): number;
export declare function fastHash(str: string): number;
export declare function getNameWithoutPackage(fullName: string): string;
/** @disabled_internal */
export declare function parseCursor(orderByProperties: Property[], value: string): PropertyAndValue[];
//# sourceMappingURL=util.d.ts.map