import { UnPromised } from '@sage/xtrem-async-helper';
import { AsyncResponse, Dict } from '@sage/xtrem-shared';
import { Application } from '../application';
import { Context, NodeFactory } from '../runtime';
import { Extend, Node, NodeQueryFilter, PropertyQueryFilter } from '../ts-api';
import { JoinLiteralValue } from '../ts-api/join';
import { DataType, DataTypeMetadata, DataTypeOptions, FieldBinding, MetaDataOptions } from './data-type';
/** Type for property paths in dot notation, like 'address.city' */
export type PropertyPath<ValT extends Node | null, SeenT = never, Depth extends unknown[] = [unknown], K extends keyof ValT = keyof ValT> = K extends string ? K extends '$' | `_${infer Unused}` ? never : ValT[K] extends Promise<infer RefT extends Node | null> ? RefT extends SeenT ? never : Depth['length'] extends 3 ? never : `${K}.${PropertyPath<RefT, SeenT | ValT, [...Depth, unknown]>}` : K : never;
export interface LookupDefinition<ValT extends Node> {
    readonly valuePath: PropertyPath<ValT>;
    readonly helperTextPath?: PropertyPath<ValT>;
    readonly imageFieldPath?: PropertyPath<ValT>;
    readonly tunnelPageIdPath?: PropertyPath<ValT>;
    readonly tunnelPage?: string;
    columnPaths: readonly PropertyPath<ValT>[];
}
export interface ReferenceDataTypeOptions<ValT extends Node | null, NodeT extends Node> extends DataTypeOptions {
    reference: () => {
        new (): ValT;
    };
    filters?: {
        lookup?: NodeQueryFilter<ValT extends Node | null ? ValT & Node : never, Extend<NodeT>>;
        control?: NodeQueryFilter<ValT extends Node | null ? ValT & Node : never, Extend<NodeT>>;
    };
    isNullable?: boolean;
    ignoreIsActive?: boolean;
    isDefault?: boolean;
    lookup: LookupDefinition<NonNullable<ValT>>;
}
export interface ReferenceDataTypeMetadata<TitleT> extends DataTypeMetadata<TitleT> {
    node: string;
    value: FieldBinding<TitleT>;
    helperText?: FieldBinding<TitleT>;
    imageField?: FieldBinding<TitleT>;
    columns: FieldBinding<TitleT>[];
    tunnelPage?: string;
    tunnelPageId?: FieldBinding<TitleT>;
}
export declare class ReferenceDataType<ValT extends Node, NodeT extends Node = Node> extends DataType<ValT, NodeT, ReferenceDataTypeOptions<ValT, NodeT>> {
    constructor(options: ReferenceDataTypeOptions<ValT, NodeT>);
    get isNullable(): boolean;
    get ignoreIsActive(): boolean;
    get isDefault(): boolean;
    get node(): string;
    /**
     * Returns the metadata of the data type.
     * This is called from 2 places:
     * - from the graphql metadata endpoint in xtrem-core, to provide the data type fragment of the response.
     * - from the metadata upgrader in xtrem-metadata, to provide the _attributes_ of reference data types.
     * In the first case the titles are returned as strings because we only need the titles for the user's locale.
     * In the second case the titles are returned as Dict<string> because we need the values for all the locales.
     * The TitleT generic type allows us to handle these two scenarios with a type-safe implementation.
     */
    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, Application, Context>): ReferenceDataTypeMetadata<TitleT>;
    static getNodeDefaultDataType(application: Application, factory: NodeFactory): ReferenceDataType<Node> | undefined;
}
export type JoinMember<T extends Node, This extends Node, K extends Exclude<keyof T, '$'>> = string | JoinLiteralValue | ((this: Extend<This>) => AsyncResponse<PropertyQueryFilter<This, UnPromised<T[K]>>>) | (T[K] extends Promise<infer U> ? (U extends Node ? PropertyJoin<U, This> : never) : never);
export type PropertyJoin<T extends Node, This extends Node = T> = Partial<{
    [K in Exclude<keyof T, '$'>]: JoinMember<T, This, K>;
}>;
export type InternalPropertyJoin<T extends Node, This extends Node = T> = Dict<JoinMember<T, This, any>>;
//# sourceMappingURL=reference-data-type.d.ts.map