import { AnyValue, type Dict } from '@sage/xtrem-shared';
import { ValidationContext } from '../ts-api/validation';
import { DataType, DataTypeMetadata, DataTypeOptions, MetaDataOptions } from './data-type';
export interface JsonDataTypeOptions extends DataTypeOptions {
}
export interface JsonDataTypeMetadata<TitleT> extends DataTypeMetadata<TitleT> {
}
export declare class JsonDataType<T = unknown, ValT extends AnyValue = AnyValue> extends DataType<ValT, T, JsonDataTypeOptions> {
    constructor(options?: JsonDataTypeOptions);
    controlValue(node: T, cx: ValidationContext, val: object): Promise<void>;
    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, any, any>): JsonDataTypeMetadata<TitleT>;
}
//# sourceMappingURL=json-data-type.d.ts.map