import { Dict } from '@sage/xtrem-shared';
import { Application } from '../application/application';
import { Context } from '../runtime';
import { ValidationContext } from '../ts-api/validation';
import { DataType, DataTypeMetadata, DataTypeOptions, MetaDataOptions } from './data-type';
export interface Enum {
    [id: number]: string;
}
export interface EnumDataTypeOptions extends DataTypeOptions {
    enum: Enum;
    filename: string;
    extends?: EnumDataType;
}
export interface EnumType {
    name: string;
    values: Dict<number>;
}
export interface EnumDataTypeMetadata<TitleT> extends DataTypeMetadata<TitleT> {
    values: {
        value: string;
        title: string | TitleT;
    }[];
    enumName: string;
}
export declare class EnumDataType<ValueT extends string | null = string, T = unknown> extends DataType<ValueT extends string ? ValueT : never, T, EnumDataTypeOptions> {
    options: EnumDataTypeOptions;
    private _packageName;
    private _values;
    private _extendedMemberInfo;
    constructor(options: EnumDataTypeOptions);
    get enum(): Enum;
    get filename(): string;
    get instanceValues(): Dict<number>;
    get enumValues(): Dict<number>;
    controlValue(node: T, cx: ValidationContext, val?: string | string[]): Promise<void>;
    numberValue(memberValue: string): number;
    stringValue(keyValue: number): ValueT;
    validateMemberValue(memberValue: string): void;
    getLocalizedValue(context: Context, memberValue: string): string;
    getLocalizedValues(context: Context): string[];
    enumName(): string;
    get packageName(): string;
    enumFullName(): string;
    get values(): ValueT[];
    compareValues(val1: string | number | null, val2: string | number | null): number;
    getEnumType(): EnumType;
    get baseDataType(): EnumDataType | undefined;
    get rootDataType(): EnumDataType | undefined;
    getLocalizedTitleKey(): string;
    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, Application, Context>): EnumDataTypeMetadata<TitleT>;
}
//# sourceMappingURL=enum-data-type.d.ts.map