/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ValidationError=exports.ValidationContext=exports.ContextValidators=void 0;const decimalLib=require("@sage/xtrem-decimal"),xtrem_shared_1=require("@sage/xtrem-shared"),loggers_1=require("../runtime/loggers"),logger=loggers_1.loggers.core;function fmt(e){return"string"==typeof e?`'${e}'`:e}class ContextValidators{constructor(e,t,a=false){this.messageContext=e,this.arg=t,this.negated=a}get context(){return this.messageContext.context}get severity(){return this.messageContext.severity}get not(){return new ContextValidators(this.messageContext,this.arg,!this.negated)}async getLocalized(e,t,a){const s=this.messageContext.localizedMessage,r=this.messageContext.context;if(s)return r.localize(s.key,s.template,await(s.data?.()));let i="";const n=a?fmt(a.v2):"";if(this.negated)i=r.localize(e,t,{v2:n});else i=r.localize(e.replace("-not-","-"),t.replace(" not "," "),{v2:n});return i.replace(/&quot;/g,'"').replace(/&#x27;/g,"'")}async empty(){if((null==this.arg||0===this.arg.length)===this.negated)return this.context.addDiagnose(this.severity,await this.getLocalized("@sage/xtrem-core/value-must-not-be-empty","value must not be empty")),true;return false}get equal(){return{to:async e=>{if(decimalLib.eq(this.arg,e)===this.negated)return this.context.addDiagnose(this.severity,await this.getLocalized("@sage/xtrem-core/value-must-not-be-equal","value must not be equal to {{v2}}",{v2:e})),true;return false}}}get greater(){return{than:async e=>{if(decimalLib.gt(this.arg,e)===this.negated)return this.context.addDiagnose(this.severity,await this.getLocalized("@sage/xtrem-core/value-must-not-be-greater-than","value must not be greater than {{v2}}",{v2:e})),true;return false}}}get less(){return{than:async e=>{if(decimalLib.lt(this.arg,e)===this.negated)return this.context.addDiagnose(this.severity,await this.getLocalized("@sage/xtrem-core/value-must-not-be-less-than","value must not be less than {{v2}}",{v2:e})),true;return false}}}get at(){return{least:async e=>{if(decimalLib.gte(this.arg,e)===this.negated)return this.context.addDiagnose(this.severity,await this.getLocalized("@sage/xtrem-core/value-must-not-be-at-least","value must not be at least {{v2}}",{v2:e})),true;return false},most:async e=>{if(decimalLib.lte(this.arg,e)===this.negated)return this.context.addDiagnose(this.severity,await this.getLocalized("@sage/xtrem-core/value-must-not-be-at-most","value must not be at most {{v2}}",{v2:e})),true;return false}}}async in(e){if(e.some(e=>decimalLib.eq(e,this.arg))===this.negated)return this.context.addDiagnose(this.severity,await this.getLocalized("@sage/xtrem-core/value-must-not-be-part-of-set","value must not be part of set [{{v2}}]",{v2:e})),true;return false}async true(){if(this.arg===this.negated)return this.context.addDiagnose(this.severity,await this.getLocalized("@sage/xtrem-core/value-must-not-be-true","value must not be true")),true;return false}async false(){if(!this.arg===this.negated)return this.context.addDiagnose(this.severity,await this.getLocalized("@sage/xtrem-core/value-must-not-be-false","value must not be false")),true;return false}async matching(e){if((null!=this.arg&&e.test(this.arg))===this.negated)return this.context.addDiagnose(this.severity,await this.getLocalized("@sage/xtrem-core/value-must-not-match","value must not match {{v2}}",{v2:e})),true;return false}async zero(){if(decimalLib.eq(this.arg,0)===this.negated)return this.context.addDiagnose(this.severity,await this.getLocalized("@sage/xtrem-core/value-must-not-be-zero","value must not be zero")),true;return false}async positive(){if(decimalLib.gt(this.arg,0)===this.negated)return this.context.addDiagnose(this.severity,await this.getLocalized("@sage/xtrem-core/value-must-not-be-positive","value must not be positive")),true;return false}async negative(){if(decimalLib.lt(this.arg,0)===this.negated)return this.context.addDiagnose(this.severity,await this.getLocalized("@sage/xtrem-core/value-must-not-be-negative","value must not be negative")),true;return false}async before(e){if((null==this.arg||this.arg.compare(e)<0)===this.negated)return this.context.addDiagnose(this.severity,await this.getLocalized("@sage/xtrem-core/value-must-not-be-before","value must not be before {{v2}}",{v2:e})),true;return false}async after(e){if((null!=this.arg&&this.arg.compare(e)>0)===this.negated)return this.context.addDiagnose(this.severity,await this.getLocalized("@sage/xtrem-core/value-must-not-be-after","value must not be after {{v2}}",{v2:e})),true;return false}}exports.ContextValidators=ContextValidators;class ValidationContext{constructor(e,t){this.node=e,this.path=t}localize(e,t,a={}){return this.node.$.context.localize(e,t,a)}addDiagnose(e,t){if(this.node.$.state.addDiagnose(e,this.path,t),e===xtrem_shared_1.ValidationSeverity.exception)throw new ValidationError(this.node)}addError(e){this.addDiagnose(xtrem_shared_1.ValidationSeverity.error,e)}addWarning(e){this.addDiagnose(xtrem_shared_1.ValidationSeverity.warn,e)}addInfo(e){this.addDiagnose(xtrem_shared_1.ValidationSeverity.info,e)}get severity(){return this.node.$.context.severity}at(...e){return new ValidationContext(this.node,e)}forSeverity(e,t){return{if:a=>({is:new ContextValidators({context:this,severity:e,localizedMessage:t},a,true)}),add:t=>this.addDiagnose(e,t),addLocalized:(t,a,s={})=>{const r=this.node.$.context.localize(t,a,s);this.addDiagnose(e,r)},withMessage:(t,a,s)=>this.forSeverity(e,{key:t,template:a,data:s})}}get info(){return this.forSeverity(xtrem_shared_1.ValidationSeverity.info)}get warn(){return this.forSeverity(xtrem_shared_1.ValidationSeverity.warn)}get error(){return this.forSeverity(xtrem_shared_1.ValidationSeverity.error)}get throw(){return this.forSeverity(xtrem_shared_1.ValidationSeverity.exception)}forExpect(e,t){return{to:{be:new ContextValidators({context:this,severity:xtrem_shared_1.ValidationSeverity.error,localizedMessage:t},e,false)},withMessage:(t,a,s)=>this.forExpect(e,{key:t,template:a,data:s})}}expect(e){return this.forExpect(e)}}exports.ValidationContext=ValidationContext;class ValidationError extends xtrem_shared_1.BusinessRuleError{constructor(e,t,a){super(t||"Validation failed",a),this.node=e,Object.setPrototypeOf(this,ValidationError.prototype),this.extensions={...this.extensions,diagnoses:e.$.context.diagnoses},this.extensions.diagnoses.forEach(e=>logger.error(()=>e.toString()))}}exports.ValidationError=ValidationError;
//# sourceMappingURL=validation.js.map