/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Activity=exports.InternalPermissionGrant=exports.InternalOperationGrant=exports.InternalBaseGrant=void 0;const _=require("lodash"),fsp=require("path"),activity_manager_1=require("../application/activity-manager"),system_properties_1=require("../runtime/system-properties");class InternalBaseGrant{constructor(t){this.type=t}get key(){return""}isOperationGrant(){return"operationGrant"===this.type}isPermissionGrant(){return"permissionGrant"===this.type}}exports.InternalBaseGrant=InternalBaseGrant;class InternalOperationGrant extends InternalBaseGrant{constructor(t,e){super("operationGrant"),this.operation=t,this.node=e}get key(){return`${this.node}.${this.operation}`}}exports.InternalOperationGrant=InternalOperationGrant;class InternalPermissionGrant extends InternalBaseGrant{constructor(t,e){super("permissionGrant"),this.permission=t,this.activity=e}get key(){return`${this.activity}.${this.permission}`}}exports.InternalPermissionGrant=InternalPermissionGrant;class Activity{#t;#e;#r=Object.create(null);#n;#a;#i;constructor(t){this.definition=t,this.#n=t.permissions,this.#a=t.permissionGrants,this.#i=t.operationGrants}get description(){return this.definition.description}get node(){return this.definition.node()}get name(){if(!this.#e)this.#e=_.camelCase(fsp.basename(this.definition.__filename).replace(/\.(js|ts|jsbz?)$/,""));return this.#e}get permissions(){return this.#n}get operationGrants(){return this.#i}get permissionGrants(){return this.#a}get package(){return this.#t}set package(t){this.#t=t}#s=Object.create(null);set flattenedPermissions(t){this.#s=t}get flattenedPermissions(){return this.#s}mergeExtension(t){t.permissions.forEach(t=>{if(!this.#n.includes(t))this.#n.push(t)}),this.#a=_.mergeWith(this.#a,t.permissionGrants,(t,e)=>{if(_.isArray(t)||_.isArray(e))return _.uniqWith([...t||[]].concat(e||[]),_.isEqual);return}),this.#i=_.mergeWith(this.#i,t.operationGrants,(t,e)=>{if(_.isArray(t)||_.isArray(e))return _.uniqWith([...t||[]].concat(e||[]),_.isEqual);return})}addGrant(t,e){if(null==this.#r[t])this.#r[t]=Object.create(null);const r=this.#r[t];if(null==r[e.key])return r[e.key]=e,true;return false}get internalGrants(){return this.#r}addNodeOperation(t,e){if(activity_manager_1.ActivityManager.checkOperation(e,t))if(this.addGrant(e,new InternalOperationGrant(e,t.name)),["create","update","delete","read"].includes(e)){if("read"!==e)this.addGrant(e,new InternalPermissionGrant("read",this.name));this.addGrant(e,new InternalPermissionGrant("lookup",this.name))}}fillFactoryGrants(t){const{operationGrants:e,permissionGrants:r,permissions:n}=this;if(n.forEach(e=>this.addNodeOperation(t,e)),e)Object.keys(e).forEach(r=>{this.addNodeOperation(t,r),e[r].forEach(t=>{t.operations.forEach(e=>{(t.on||[()=>this.node]).forEach(t=>{this.addGrant(r,new InternalOperationGrant(e,t().name))})})})});if(r)Object.keys(r).forEach(e=>{if(activity_manager_1.ActivityManager.checkOperation(e,t))this.addGrant(e,new InternalOperationGrant(e,t.name));r[e].forEach(t=>{t.permissions.forEach(r=>{t.on.forEach(t=>{this.addGrant(e,new InternalPermissionGrant(r,t().name))})})})});this.permissions.forEach(e=>{if(activity_manager_1.ActivityManager.checkOperation(e,t))this.addGrant(e,new InternalOperationGrant(e,this.node.name))})}fillInternalGrants(t){const e=t.getFactoryByName(this.node.name);if(this.fillFactoryGrants(e),e.isAbstract)t.getAllFactories().filter(t=>t.isSubNodeOf(e.name)).forEach(t=>{this.fillFactoryGrants(t)})}fillInheritedInternalGrants(t,e){const r=Object.entries(this.#r);for(const[n,a]of r){const r=Object.values(a).filter(t=>t.isOperationGrant());if(this.addOperationGrants(t,Object.values(r),n,e))return true}return false}addOperationGrants(t,e,r,n){for(const a of e){const e=t.getFactoryByName(a.node);if(["create","update","delete","read","lookup"].includes(a.operation)){if("lookup"!==a.operation){if("read"!==a.operation&&this.addGrant(r,new InternalOperationGrant("read",a.node)))return true;if(this.addGrant(r,new InternalOperationGrant("lookup",a.node)))return true}if(this.addExtendedVitalFactoriesGrants(e,a,r))return true}if("lookup"!==a.operation){const t=n[e.name]??e.properties.filter(t=>t.isForeignNodeProperty()&&(t.isReferenceProperty()&&t.canLookup||!t.isReferenceProperty())&&!system_properties_1.SystemProperties.isUserManagementProperty(t)&&!system_properties_1.SystemProperties.isAttachmentsProperty(t)&&!t.isVitalParent).map(t=>t.targetFactory);if(!n[e.name])n[e.name]=t;for(const e of t)if(this.addGrant(r,new InternalOperationGrant("lookup",e.name)))return true}}return false}addExtendedVitalFactoriesGrants(t,e,r){for(const n of t.extendedVitalFactories){if(this.addGrant(r,new InternalOperationGrant(e.operation,n.name)))return true;switch(e.operation){case"lookup":break;case"read":if(this.addGrant(r,new InternalOperationGrant("lookup",n.name)))return true;break;default:if(this.addGrant(r,new InternalOperationGrant("read",n.name))||this.addGrant(r,new InternalOperationGrant("lookup",n.name)))return true}}return false}getLocalizedTitleKey(){return`${this.#t}/activity__${_.snakeCase(this.name)}__name`}getPermissionLocalizedTitleKey(t){return`${this.#t}/permission__${_.snakeCase(t)}__name`}}exports.Activity=Activity;
//# sourceMappingURL=activity.js.map