/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.mapGraphQlResult=exports.Test=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_shared_1=require("@sage/xtrem-shared"),chai_1=require("chai"),fs=require("fs"),graphql_1=require("graphql"),fsp=require("path"),application_1=require("../application"),node_state_1=require("../node-state"),context_1=require("../runtime/context"),loggers_1=require("../runtime/loggers"),table_1=require("../sql/schema/table"),condition_variable_1=require("./condition-variable"),mocker_1=require("./mocker"),tables_1=require("./tables"),test_reset_tables_1=require("./test-reset-tables"),logger=loggers_1.loggers.test;function makeUserTestOption(t,e){const i={skipMocks:true,testActiveServiceOptions:e};if(t.user)i.user={email:t.user,userName:""};if(t.cookie){const e={tenantId:t.tenantId||Test.defaultTenantId,...t.auth};if(i.config={response:{constructor:{name:"ServerResponse"},cookie:"function"==typeof t.cookie?t.cookie:()=>{},locals:{auth:e}}},e.login)i.user={email:e.login,userName:""}}else if(t.auth)i.auth=t.auth;if(t.tenantId)i.config={...i.config,tenantId:t.tenantId};return i}const getSetupModule=t=>{if(!fs.existsSync(fsp.join(t,"test/setup.ts")))return;return delete require.cache[require.resolve(fsp.join(t,"test/setup.ts"))],require(fsp.join(t,"test/setup"))};function runSetup(t){const e=getSetupModule(t);if(e)if("function"==typeof e.setup)e.setup();else console.warn(`'setup.ts' file under '${fsp.join(t,"test/graphql")}' does not contain any function called 'setup'!`)}const applyContextMocks=async(t,e)=>{if(e.locale)await t.setTestLocale(e.locale);if(e.currentLegislationCode)t.currentLegislationCode=e.currentLegislationCode};class Test{static{this._schemaExists={}}static{this.defaultTenantId="7".repeat(21)}static{this.defaultEmail="unit.test@acme.com"}static{this.defaultTenantName="Tenant for tests (automatic creation)"}static get application(){return this._application}static set application(t){this._application=t}static async ensureTestTenantExists(t){if("@sage/xtrem-cop-test"===t.application.mainPackage.name)return;await context_1.Context.tenantManager.ensureTenantExists(t,{tenant:{id:Test.defaultTenantId,name:Test.defaultTenantName},customer:{id:Test.defaultTenantId,name:"Customer for tests (automatic creation)"}})}static withCommittedContext(t,e){return Test.application.withCommittedContext(e?.tenantId||Test.defaultTenantId,t,e)}static withUncommittedContext(t,e){return Test.application.withUncommittedContext(e?.tenantId||Test.defaultTenantId,t,e)}static withReadonlyContext(t,e){return Test.application.withReadonlyContext(e?.tenantId||Test.defaultTenantId,t,e)}static get state(){return this._state}static set state(t){this._state=t}static get options(){if(!this.application)throw new Error("invalid test context: Test.application is undefined");return{config:{...xtrem_config_1.ConfigManager.current,...this._config},application:this.application}}static patchConfig(t){this._config={...this._config,...t}}static configForTest(){return this._config}static fixRequestMiddleWare(t,e,i){e.locals.config=xtrem_config_1.ConfigManager.current,e.locals.context={email:Test.defaultEmail,tenantId:Test.defaultTenantId},e.locals.auth={...e.locals.auth,login:e.locals.context.email,tenantId:e.locals.context.tenantId,auth0:"auth0"},i()}static convertOptions(t){const e=this.options,i="unit.test@acme.com",a=["setup","test"],s=t?.config?.layers||a;if(!e.config)e.config=xtrem_config_1.ConfigManager.current;if(e.config.storage?.managedExternal){const i="ADMIN";e.config.user=t?.user?t.user?.userName||i:t?.config?.userName||i}else{if(!t?.auth?.login)e.config.email=t?.user?t.user?.email||i:t?.config?.email||i,e.userEmail=e.config.email,e.config.user=e.config.email;e.auth=t?.auth}return e.response=t?.config?.response||{},e.request=t?.config?.request||{},e.testNowMock=t?.now||"",e.source=t?.source,e.testLayers=s,e.testMode=true,e.testConfig=t&&{...t},e.locale=t?.locale||"base",e.noLazyLoading=t?.noLazyLoading,e.testActiveServiceOptions=this.getTestActiveServiceOptions(t),e.tenantId=t?.tenantId,e.timeLimitAsTimestamp=t?.timeLimitAsTimestamp,e}static isServiceOptionEnabledByTestConfig(t){const e=this._config?.serviceOptions?.level;if("released"===e)return"released"===t.status;if("experimental"===e)return"workInProgress"!==t.status;return true}static getTestActiveServiceOptions(t){const e=[],addServiceOption=t=>{if(!e.includes(t))e.push(t);if(t.activates)t.activates().forEach(addServiceOption)};if(t?.testActiveServiceOptions)t.testActiveServiceOptions.forEach(addServiceOption);else{if(xtrem_config_1.ConfigManager.current.storage?.managedExternal)return;if(Object.values(this.application.serviceOptionsByName).filter(t=>t.isActiveByDefault).forEach(addServiceOption),Test.cliActiveServiceOptions)Test.cliActiveServiceOptions.forEach(addServiceOption)}return e.filter(t=>this.isServiceOptionEnabledByTestConfig(t))}static createPlugins(t){if(!t?.mocks)return t;if(!t?.directory)throw new Error("Mocks provided without a directory.");if(t.directory=t.directory.replace(`${fsp.sep}build${fsp.sep}`,fsp.sep),!t?.scenario)t.scenario=fsp.parse(t.directory).name;if(chai_1.assert.isArray(t.mocks,"mocks must be an array."),t.plugins=t.plugins||[],t.mocks)t.plugins.map(t=>t.name).forEach(e=>{if(t.mocks?.includes(e))throw new Error(`Cannot mock and supply a plugin for the same module, ${e}`)});return t.plugins=[...t.plugins,...t.mocks.map(e=>{const i=mocker_1.mockPlugins[e];return chai_1.assert.exists(i,`No plugin found for '${e}' mock.`),new i(e,fsp.join(t.directory,e),t.scenario)})],t}static async preliminarySteps(t){if(t.directory)t.directory=t.directory.replace(`${fsp.sep}build${fsp.sep}`,fsp.sep);Test.applyDateMocks(t);const e=this.createPlugins(t),i=this.convertOptions(e);if(!i.config)i.config=xtrem_config_1.ConfigManager.current;if(!i.config.storage?.managedExternal){const t=this.application.schemaName;if(!Test._schemaExists[t])Test._schemaExists[t]=true,await application_1.Application.createDbSchema(t)}return{testOptions:e,contextOptions:i}}static withContext(t,e={}){const isInvalid=t=>{if(t.baseFactory&&t.baseFactory.table&&isInvalid(t.baseFactory))return true;return t.table&&t.table.testStatus!==table_1.TestStatus.loaded},i=Test.application.getSqlPackageFactories().filter(isInvalid);return this.withMocks(async(e,a)=>(await(0,xtrem_async_helper_1.asyncArray)(i).forEach(async t=>{await t.fixAutoIncrementSequences(null),t.table.testStatus=table_1.TestStatus.loaded}),Test.withUncommittedContext(i=>Test.withContextMocks(i,{testOptions:e,contextOptions:a},()=>t(i)),a)),e)}static async withMocks(t,e={}){const{testOptions:i,contextOptions:a}=await this.preliminarySteps(e);try{return await t(i,a)}finally{if(this._timeStubs)Test.restoreDateMocks()}}static async withCommittedServiceOptions(t,e,i){if(!i.length)return e();const a=await this.application.asRoot.withCommittedContext(t,async t=>{const e=await(0,xtrem_async_helper_1.asyncArray)(i).filter(async e=>!await t.isServiceOptionEnabled(e)).toArray();return this.application.serviceOptionManager.activateServiceOptions(t,e)});try{return await e()}finally{await this.application.asRoot.withCommittedContext(t,t=>this.application.serviceOptionManager.deactivateServiceOptions(t,a))}}static withUserContext(t,e,i){const a=this.convertOptions({skipMocks:true,testActiveServiceOptions:i});return this.withCommittedServiceOptions(a.tenantId||Test.defaultTenantId,()=>Test.withContext(t,makeUserTestOption(e,i)),i||[])}static readonly(t,e={}){return this.withMocks((e,i)=>Test.withReadonlyContext(a=>Test.withContextMocks(a,{testOptions:e,contextOptions:i},()=>t(a)),i),e)}static committed(t,e={}){return this.withMocks((e,i)=>Test.withCommittedContext(a=>Test.withContextMocks(a,{testOptions:e,contextOptions:i},()=>t(a)),i),e)}static uncommitted(t,e={}){return this.withMocks((e,i)=>Test.withUncommittedContext(a=>Test.withContextMocks(a,{testOptions:e,contextOptions:i},()=>t(a)),i),e)}static async setup(t){const e=xtrem_config_1.ConfigManager.load(t.dir,"test");if(!e.storage?.managedExternal){const e=Date.now();await application_1.Application.createDbSchema(t.schemaName),logger.info(`created application schema ${t.schemaName} (${Date.now()-e} ms)`)}this.application=t,t.getAllNodes()}static{this.getTestSchemaName=t=>`${require(fsp.resolve(t,"package.json")).name.replace(/@[a-z][a-z0-9.-]*\//,"").replace(/-/g,"_")}_test`}static{this.getDirectory=(t,e)=>{const i=fsp.join(t,e);if(fs.existsSync(i)&&!fs.statSync(i).isDirectory())return t;return""}}static createCliApplication(t){if(t.api)t.api={...t.api,nodes:{...t.api.nodes}};const e=fsp.resolve(t.buildDir,"..");xtrem_config_1.ConfigManager.load(e);return new application_1.Application({schemaName:this.getTestSchemaName(e),applicationType:"dev-tool",...t})}static async createTestApplication(t){xtrem_config_1.ConfigManager.load(__dirname);const e=new application_1.Application({schemaName:t.schemaName||xtrem_config_1.ConfigManager.current.storage?.managedExternal?"xtrem_external":this.getTestSchemaName(fsp.resolve(t.buildDir,"..")),applicationType:"test",...t});if(xtrem_config_1.ConfigManager.current.storage?.managedExternal)return e;const i={testLayers:["setup","test"],userEmail:context_1.rootUserEmail,withoutTransactionUser:true};return e.activityManager.resolvePermissions(),await test_reset_tables_1.TestResetTables.resetTestTables(e,i),e.startListeners(["testListen"]),e}static async setupApi(t,e){return await Test.setup(t),e.use((t,e,i)=>{e.locals.config=xtrem_config_1.ConfigManager.current,e.locals.config.email=e.locals.config.email||"unit.test@acme.com",i()}),t}static initializeManagers(t){context_1.Context.managers.forEach(e=>e.initializeManager(t))}static async cleanUp(t){const e=t.getAllSortedFactories().slice().reverse();await(0,xtrem_async_helper_1.asyncArray)(e).forEach(t=>(0,tables_1.dropTestTable)(t.nodeConstructor))}static applyDateMocks(t){if(this._timeStubs={},t.now&&t.today)throw new xtrem_shared_1.LogicError("specify 'now' or 'today' in test options but not both");if(t.now)xtrem_date_time_1.datetime.overrideNow(t.now);else if(t.today)xtrem_date_time_1.datetime.overrideNow(`${t.today}T12:00:00Z`)}static{this.restoreDateMocks=()=>{xtrem_date_time_1.datetime.overrideNow(null)}}static withContextMocks(t,e,i){if(e.testOptions.skipMocks)return i();return mocker_1.Mocker.withMocks(async()=>(runSetup(t.application.dir),await applyContextMocks(t,e.testOptions),i()),e.testOptions.plugins)}static createConditionVariable(t){return new condition_variable_1.ConditionVariable(t)}static async rollbackCache(t){if("test"!==t.application.applicationType)throw new Error("Cannot rollback cache outside of tests");await t.flushDeferredSaves(),await t.flushDeferredActions(),t.transaction.rollbackCache()}static async graphql(t,e){return(0,graphql_1.graphql)({schema:await Test.application.getGraphQLSchema(),source:e,contextValue:t})}static{this.hacks={isNodeStateUpdatable:t=>"updatable"===t.$.state.status,setNodeStateUpdatable(t){t.$.state.status=node_state_1.StateStatus.updatable}}}}function mapGraphQlResult(t){if(!t.errors)return t;return{...t,errors:t.errors.map(t=>t.toJSON())}}exports.Test=Test,exports.mapGraphQlResult=mapGraphQlResult;
//# sourceMappingURL=test.js.map