/** @ignore */ /** */
import { AsyncResponse } from '@sage/xtrem-async-helper';
import { AnyValue, Dict } from '@sage/xtrem-shared';
export declare abstract class Plugin {
    readonly name: string;
    readonly path: string;
    readonly scenario: string;
    constructor(name: string, path: string, scenario: string);
    mock(): any;
}
export declare class Mocker {
    /**
     * static attribute that stores a set of all the active mock plugins
     */
    private static plugins;
    /**
     * Add plugin to static plugin set
     * @param plugin
     */
    private static addPlugin;
    /**
     * Execute body with passed plugins in enabled
     * @param body
     * @param mockerPlugins
     */
    static withMocks<T extends AnyValue | void>(body: () => AsyncResponse<T>, mockerPlugins?: Plugin[]): Promise<T>;
    /**
     * return the mock for passed module or execute the standard require of the calling module (moduleRequire)
     * @param module
     * @param moduleRequire
     */
    static get(module: string, moduleRequire: any): any;
}
export declare class AxiosPlugin extends Plugin {
    private arrayCounter;
    private entries;
    /**
     * Return the mock for the axios module
     */
    mock(): any;
}
export declare const mockPlugins: Dict<any>;
//# sourceMappingURL=mocker.d.ts.map