import { StaticThis } from '../../decorators';
import { Context, DataSettingsManager } from '../../runtime/context';
import { Node } from '../../ts-api';
export declare class TestSysVendor extends Node {
    /**
     * the vendor's name
     */
    readonly name: Promise<string>;
    /**
     * the vendor's description
     */
    readonly description: Promise<string>;
}
/**
 * A mock for DataSettingsManager: should only be used for unit-tests
 */
declare class DataSettingsManagerMock implements DataSettingsManager {
    getSysVendorNode(): StaticThis<Node>;
    sageVendorId(context: Context): number;
    initializeManager(_context: Context): void;
}
export declare const dataSettingsManagerMock: DataSettingsManagerMock;
export {};
//# sourceMappingURL=data-settings-manager-mock.d.ts.map