/**
 * Utility class for tests that need synchronization between concurrent tasks
 *
 * See https://en.wikipedia.org/wiki/Monitor_(synchronization)#Condition_variables
 *
 * This is a simplistic implementation with promises.
 * Provides only `notifyAll`, not `notify`.
 */
export declare class ConditionVariable {
    readonly name: string;
    /**
     * Waits on the condition to be notified
     */
    wait(): Promise<void>;
    /**
     * Notifies all the waiters on this condition
     */
    notifyAll(): void;
}
//# sourceMappingURL=condition-variable.d.ts.map