/**
 * Special assert function to compare actual and expected values in tests.
 *
 * It checks if `expected` is a subset of `actual` and throws an error if not.
 *
 * It does not check all the members of `actual`.
 * It only checks the ones that are present in `expected`.
 *
 * It supports some special syntaxes:
 * -    if `expected` is a string starting with a tilde (`~`), it is interpreted as a regular expression
 *      and the actual value is matched against it.
 * -    if `expected` is the string `<<undefined>>`, it checks if the actual value is `undefined`.
 *
 * Note: if you want strict equality with a string starting with a tilde use ~^your_string$.
 *
 * Examples:
 *  - `assertDeepPartialMatch({ a: 1, b: { c: 2, d: 3 }, e: 4  }, { a: 1, b: { d: 3 } })` passes
 *  - `assertDeepPartialMatch({ a: 1, b: { c: 2, d: 3 }, e: 4  }, { a: 1, b: { d: 3 }, f: 5 })` does not pass.
 *  - `assertDeepPartialMatch({ a: 'hello', b: 'world' }, { a: 'hello' , b: '~orl' })` passes
 *  - `assertDeepPartialMatch({ a: 'hello', b: 'world' }, { a: 'hello' , b: 'orl' })` does not pass
 *  - `assertDeepPartialMatch({ a: 'hello' }, { a: 'hello' , b: '<<undefined>>' })` passes
 */
export declare function assertDeepPartialMatch(actual: any, expected: any, message?: string): void;
//# sourceMappingURL=assert-utils.d.ts.map