import { AsyncResponse } from '@sage/xtrem-async-helper';
import { ClientArtifactUsedLiterals, LocalizedLiteral } from '@sage/xtrem-i18n';
import { AccessStatus, Dict, MetaCustomFieldsArray, MetaCustomizableNodesArray } from '@sage/xtrem-shared';
import { Context } from '../runtime/context';
import { NodeExportTemplate } from '../runtime/core-hooks';
import { TextStream } from '../types';
import { ApplicationArtifact, ClientArtifactMetadata, ClientArtifactType, NodeAccess, PageArtifact } from './pages/client-service';
declare enum StorageStatus {
    notStarted = 0,
    done = 1
}
export declare enum ArtifactDataTypeEnum {
    json = 1,
    js = 2,
    csv = 3,
    ts = 4,
    meta = 5
}
export type ArtifactDataType = keyof typeof ArtifactDataTypeEnum;
export interface PackArtifactInterface {
    packageName: string;
    path: string;
    content: TextStream | ClientArtifactMetadata;
    dataType: ArtifactDataType;
    condition: (pack: PackArtifactInterface) => boolean;
    type?: string;
}
export declare const generateEnumKey: (e: string) => string;
export declare function getArtifactDataType(fileName: string): ArtifactDataType | undefined;
export interface ArtifactFilter {
    packageOrPage: string;
    exactMatch: boolean;
    pageNode?: string;
}
export declare class ArtifactManager {
    static progress: StorageStatus;
    private static _applicationArtifactsByType;
    private static _packArtifactByKey;
    private static ensureArtifactsCachedFunnel;
    static clearStored(): void;
    /**
     * Ensure that all pack artifacts of the application are cached in memory prior to retrieval
     * This is fired once per container with an adivisory lock to avoid the artifact being inserted twice into cache.
     *
     * @param application
     */
    private static ensureArtifactsCached;
    /**
     * Cache a specific artifact type of the application from the file system to memory
     * @param context
     * @param artifactType
     */
    private static cacheArtifacts;
    private static cacheArtifact;
    private static getPackArtifactInterface;
    static getArtifactTitle(context: Context, artifactType: ClientArtifactType, artifactEntry: ApplicationArtifact): string;
    static getArtifactDescription(context: Context, artifactType: ClientArtifactType, artifactEntry: ApplicationArtifact): string;
    static addUsedStringsKey(literals: ClientArtifactUsedLiterals | undefined, usedStringKeys: string[]): void;
    /**
     * Resolve the literals for the artifact, including the literals from the extensions and fragments
     * @param context
     * @param artifactType
     * @param artifact
     * @returns
     */
    static resolveArtifactStrings(context: Context, artifactType: ClientArtifactType, artifact: ApplicationArtifact): Promise<LocalizedLiteral[]>;
    private static getArtifacts;
    private static getJsBundles;
    private static completeWithJsonMeta;
    static getParsedContent(packArtifact: PackArtifactInterface): ClientArtifactMetadata;
    /**
     * Resolves to the customizable nodes based on the vital tree of the page node.
     * Used by the client side to have the list of customizable nodes relevant to the page.
     * @param context
     * @param artifact
     * @returns
     */
    static resolvePageCustomizableNodesWizard(context: Context, artifact: ApplicationArtifact): MetaCustomizableNodesArray | undefined;
    /**
     * A list of customizable nodes for the page, constructed from ALL the nodes used on the page.
     * @param context
     * @param artifact
     * @returns
     */
    static resolvePageCustomizableNodes(context: Context, artifact: ApplicationArtifact): Promise<MetaCustomizableNodesArray>;
    /**
     * Get a dictionary of custom fields for the page, based on ALL the nodes used on the page.
     * @param context
     * @param artifact
     * @returns
     */
    static resolvePageCustomFields(context: Context, artifact: ApplicationArtifact): Promise<MetaCustomFieldsArray | undefined>;
    /**
     * Get the export templates for the page, based on ALL the nodes used on the page.
     * @param context
     * @param artifact
     * @returns
     */
    static resolvePageExportTemplatesByNode(context: Context, artifact: ApplicationArtifact): Promise<NodeExportTemplate[]>;
    static resolvePageAccess(context: Context, artifact: ApplicationArtifact): AsyncResponse<AccessStatus>;
    static resolveAccess(context: Context, artifact: ApplicationArtifact): Promise<NodeAccess[]>;
    /**
     * Convert the pack artifact to a meta pack artifact.
     * @param context
     * @param packArtifact
     * @param artifactType
     * @returns
     */
    private static convertToPackArtifact;
    private static getMetaBundles;
    /**
     * Retrieves the artifact information for the specified key
     * The key is the <package name>/<artifact name>
     * Example: `@sage/xtrem-sales/SalesOrder`
     * @param context
     * @param key
     * @param locale
     * @returns
     */
    static getPageArtifact(context: Context, key: string): Promise<PageArtifact | null>;
    /**
     * Retrieves the artifact information for the specified key
     * The key is the <package name>/<artifact name>
     * Example: `@sage/xtrem-sales/SalesOrder`
     * @param context
     * @param key
     * @param locale
     * @returns
     */
    private static getArtifact;
    /**
     * This list search in the file system
     * @param key
     * @param artifactType
     */
    static listAllClientArtifactsFromStorage(context: Context, artifactType: ClientArtifactType): Promise<ApplicationArtifact[]>;
    /**
     * Find the artifacts for the packages that are active for the current tenant.
     */
    private static getPackArtifacts;
    /**
     * Read from file system
     * @param key
     * @param artifactType
     */
    static readClientArtifact(context: Context, artifactType: ClientArtifactType, filter: ArtifactFilter): Promise<ApplicationArtifact | null>;
    /**
     * Get extensions by page key
     * @param key
     * @param artifactType
     */
    static getExtensionsForPage(context: Context, key: string, artifactType: ClientArtifactType): Promise<ApplicationArtifact[]>;
    static getArtifactExtensions(context: Context, key: string, artifactType: ClientArtifactType): Promise<ApplicationArtifact[]>;
    /**
     * Get the page fragments for the page
     * @param context
     * @param artifact
     * @returns
     */
    static getArtifactPageFragments(context: Context, artifact: ApplicationArtifact): Promise<Dict<ApplicationArtifact>>;
    static getArtifactNodes(context: Context, artifact: ApplicationArtifact): Promise<string[]>;
    static queryPackArtifacts(context: Context, filter: Partial<PackArtifactInterface>): Promise<PackArtifactInterface[]>;
    /**
     * In the ui config there can be inclusion and exclusion globs provided,
     *  we can use these checks to see if the artifact path conforms to the inclusion/exclusion rules
     * Exclusions will take precedence over inclusions
     * @param artifactPath
     * @returns
     */
    private static checkArtifactWithConfig;
    /**
     * Iterate through all xtrem application packages and read their client artifacts.
     * @param applications
     * @param artifactType
     */
    private static readClientArtifactsFromFiles;
}
export {};
//# sourceMappingURL=artifact-manager.d.ts.map