/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.TriggerBuilder=void 0;const sql_context_1=require("../../sql-context/sql-context"),naming_1=require("../naming");class TriggerBuilder{static{this._builders={}}constructor(e,t){this.name=e,this.when=t.when,this.event=t.event,this.options=t.options,this.functionParametersProvider=t.functionParametersProvider}static _getKey(e,t,r,i){const n=[e,t,r];if(i)n.push(i);return n.join("/")}get key(){return TriggerBuilder._getKey(this.name,this.when,this.event,this.options)}static createTableTriggerBuilder(e,t){return this.registerBuilder(new TriggerBuilder(e,t))}static registerBuilder(e){const t=e.key,r=TriggerBuilder._builders[t];if(r)return r;return TriggerBuilder._builders[t]=e,e}static getBuilder(e,t,r,i){const n=TriggerBuilder._getKey(e,t,r,i);let s=TriggerBuilder._builders[n];if(!s)if(!/^notify_/.test(e))s=TriggerBuilder.createTableTriggerBuilder(e,{when:t,event:r});else throw new Error(`No builder was registered for key : ${n}`);return s}static getBuilderForTrigger(e){return TriggerBuilder.getBuilder(e.name,e.when,e.event,e.options)}getSqlToCreateTrigger(e){return`DO $$ BEGIN\n            CREATE TRIGGER ${this.name}\n            ${this.when.toUpperCase()} ${this.event.toUpperCase()} ON ${sql_context_1.SqlContext.getFullTableDefName(e)}\n            FOR EACH ROW\n            EXECUTE PROCEDURE ${this.getFunctionFullname(e)}(${this.getFunctionParameters(e)});\n            EXCEPTION\n                WHEN others THEN null;\n            END $$;`}getFunctionParameters(e){return this.functionParametersProvider?this.functionParametersProvider(e):""}getDefinition(e){return{name:this.name,event:this.event,when:this.when,options:this.options,functionName:this.getFunctionFullname(e),functionParameters:this.getFunctionParameters(e)}}getFunctionFullname(e){if(this.useDedicatedFunction)return`${e.schemaName}.${(0,naming_1.makeName63)(`${e.tableName}_${this.name}`)}`;return`${e.schemaName}.${this.name}`}get useDedicatedFunction(){return false}getSqlToCreateDedicatedFunction(e){return}getSqlToDrop(e){let t=`DROP TRIGGER IF EXISTS ${this.name} ON ${sql_context_1.SqlContext.getFullTableDefName(e)};`;if(this.useDedicatedFunction)t=`${t}\nDROP FUNCTION IF EXISTS ${this.getFunctionFullname(e)}();`;return t}}exports.TriggerBuilder=TriggerBuilder;
//# sourceMappingURL=trigger-builder.js.map