import { Application } from '../../application';
import { Context } from '../../runtime/context';
import { SchemaSqlContext } from './schema-sql-context';
interface TableOptions {
    errorsAsWarnings: boolean;
    isShared?: boolean;
}
interface SqlResult {
    success: boolean;
    rowCount: number;
}
export declare class UpdateSqlContext extends SchemaSqlContext {
    protected application: Application;
    constructor(application: Application);
    /**
     * Tries to update a table and returns whether the update succeeded
     */
    updateTable(context: Context, name: string, dataToUpdate: {
        columnName: string;
        value: any;
    }[], options?: TableOptions): Promise<SqlResult>;
    /**
     * Tries to delete a table and returns whether the drop succeeded
     */
    deleteFromTable(context: Context, name: string, options?: TableOptions): Promise<SqlResult>;
    deleteFromTables(context: Context, tablesToDelete: string[], options?: TableOptions): Promise<SqlResult>;
}
export {};
//# sourceMappingURL=update-table-context.d.ts.map