/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SequenceSqlContext=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),_1=require("."),runtime_1=require("../../runtime"),mapper_1=require("../mapper"),sql_context_1=require("./sql-context");class SequenceSqlContext extends _1.SchemaSqlContext{constructor(e,t){super(e),this.tableName=t}async getSequenceName(e,t){const n=sql_context_1.SqlContext.getFullTableName(this.schemaName,this.tableName);try{const a=`SELECT pg_get_serial_sequence('${n}', '${t}') sequence_name;`,s=await this.execute(e,a);return s&&s[0]&&s[0].sequence_name}catch(e){return void sql_context_1.SqlContext.logger.warn(`Could not find sequence for ${n}.${t}`)}}async alterSequence(e,t,n,a,s){sql_context_1.SqlContext.logger.verbose(()=>`Alter sequence '${n}`);const r=xtrem_config_1.ConfigManager.current,c=r.storage?.sql?.maxTries??120,i=r.storage?.sql?.delayBeforeRetry??1e3,o=`\n            DO\n            $$\n            BEGIN\n                SET LOCAL lock_timeout = '100ms';\n                LOCK TABLE ${t} IN SHARE MODE;\n                SELECT setval('${n}', COALESCE((SELECT GREATEST(MAX(${a}), ${s}) + 1 FROM ${t}), 1), false);\n                COMMIT;\n            EXCEPTION WHEN others THEN\n                ROLLBACK;\n            END;\n            $$\n            LANGUAGE PLpgSQL;`;await(0,runtime_1.retry)(()=>this.execute(e,o,[]),{maxTries:c,delayBeforeRetry:i})}nextSequence(e){return this.withConnection(t=>this.getNextSequenceByColumnName(t,e))}async getNextSequence(e,t){const n=`SELECT CASE WHEN is_called THEN last_value + 1 ELSE last_value END last_value FROM ${t};`,a=await this.execute(e,n);if(a&&a[0]&&a[0].last_value)return a[0].last_value;return 1}async getNextSequenceByColumnName(e,t){const n=await this.getSequenceName(e,t);if(n)return this.getNextSequence(e,n);return 1}async fixAutoIncrementSequence(e,t,n){await this.fixAutoIncrementSequences(e,[t],n)}async fixAutoIncrementSequences(e,t,n={}){const{newMaxValue:a}=n,s=this.application.getFactoryByTableName(this.tableName);await this.withConnection(n=>(0,xtrem_async_helper_1.asyncArray)(t).forEach(async t=>{const r=sql_context_1.SqlContext.getFullTableName(this.schemaName,this.tableName),c=await this.getSequenceName(n,t);if(c){if("test"!==this.application.applicationType&&null==a&&t===mapper_1.idColumnName){const t=s.isSharedByAllTenants?`SELECT null as ${mapper_1.tenantIdColumnName}, max(_id) as "max" FROM ${r}`:`SELECT ${mapper_1.tenantIdColumnName}, max(_id) as "max" FROM ${r} GROUP BY ${mapper_1.tenantIdColumnName}`,a=await this.execute(n,t,[]),i=Math.max(...a.map(e=>e.max)),o=s.isSharedByAllTenants?i:a.filter(t=>t[mapper_1.tenantIdColumnName]===e)[0]?.max||0,l=await this.getNextSequence(n,c);if(o<=i&&l>i)return}if(!a){const e=`SELECT max(${t}) max_val from ${r};`,a=(await this.execute(n,e))[0].max_val;if(a)await this.alterSequence(n,r,c,t,a)}else await this.alterSequence(n,r,c,t,a)}}))}async dropSequence(e){try{return await this.withConnection(async t=>{sql_context_1.SqlContext.logger.verbose(()=>`Drop sequence '${e}`),await this.execute(t,`DROP SEQUENCE ${e}`)}),true}catch(t){return sql_context_1.SqlContext.logger.warn(`Could not drop sequence for ${e} : ${t.stack}`),false}}async dropAutoIncrementSequence(e){await this.dropAutoIncrementSequences([e])}async dropAutoIncrementSequences(e){await this.withConnection(t=>(0,xtrem_async_helper_1.asyncArray)(e).forEach(async e=>{const n=await this.getSequenceName(t,e);if(n)await this.dropSequence(n)}))}}exports.SequenceSqlContext=SequenceSqlContext;
//# sourceMappingURL=sequence-sql-context.js.map