import { SqlReadTableSchemaOptions, TableDefinition } from '@sage/xtrem-postgres';
import { Dict } from '@sage/xtrem-shared';
import { Context } from '../..';
import { SchemaSqlContext } from './schema-sql-context';
/**
 * Returns whether a column name matches a system column
 * @param colName
 */
export declare function isSystemColumn(colName: string): boolean;
/**
 * Returns the table definition of a table (from its name)
 */
export declare function readTableSchema(context: Context, tableName: string, options: SqlReadTableSchemaOptions): Promise<TableDefinition>;
/**
 * Returns the table definitions of all the provided tables (from thier name) or all the table if no name is provided
 */
export declare function readTableSchemas(context: Context, tableNames: string[], options: SqlReadTableSchemaOptions): Promise<Dict<TableDefinition>>;
/**
 * Returns the tables in the database for the application schema
 */
export declare function readTablesForSchema(context: Context): Promise<string[]>;
export declare class ReadTableSqlContext extends SchemaSqlContext {
    readSchema(tableName: string, options?: SqlReadTableSchemaOptions): Promise<TableDefinition>;
    private _getOrInitTableDef;
    /**
     * Read all the tables of the schema
     * @returns list of tables
     */
    readTablesForSchema(): Promise<string[]>;
    /**
     *
     * @param tableNames if [], will return the table definitions for all the tables, in a row
     * @param options
     * @returns
     */
    readTableDefinitions(tableNames: string[], options?: SqlReadTableSchemaOptions): Promise<Dict<TableDefinition>>;
    /**
     * Completes a set of tableDef with their comments (table, columns, ...)
     * @param tableDef
     */
    private _fillComments;
    private _fillUpColumnDefinitionForEnums;
    /**
     * Parses a SQL row to a columnDefinition (refer to fillColumnInfos to get the format of the SQL row)
     * @param rrow
     * @returns
     */
    private _sqlRowToColumnDefinition;
    private fillColumnInfos;
    private static _transformSqlArgs;
    private fillIndexInfos;
    private _fillForeignKeyInfo;
    private fillTableTriggers;
}
//# sourceMappingURL=read-table-sql-context.d.ts.map