import { PoolClient, SqlCreateTableOptions, SqlObjectJsonComment, TableDefinition, TriggerDefinition } from '@sage/xtrem-postgres';
import { Application } from '../../application';
import { Context } from '../../runtime/context';
import { SchemaSqlContext } from './schema-sql-context';
export declare class ModifyTableSqlContext extends SchemaSqlContext {
    readonly tableDef: TableDefinition;
    /** @disabled_internal */
    constructor(application: Application, tableDef: TableDefinition);
    private createTableFromTableDefinitionWithConnection;
    createTableFromTableDefinition(options?: SqlCreateTableOptions): Promise<void>;
    createTemporaryTable(context: Context): Promise<void>;
    /**
     *  Give a user the 'select/update/insert/delete' rights to a table
     */
    giveUserRightsToTable(login: string): Promise<void>;
    /**
     * Create a bunch of triggers from their definition
     */
    createTriggers(triggers: TriggerDefinition[], client?: PoolClient): Promise<void>;
    /**
     * Drop a bunch of triggers from their definition
     */
    dropTriggers(triggers: TriggerDefinition[], client?: PoolClient): Promise<void>;
    private get tableName();
    private createTableColumns;
    private createPrimaryKey;
    /**
     * Returns the SQL query to execute to add/update a comment on a table or a column
     */
    static getSqlToComment(objectType: 'table' | 'column' | 'foreignKey', objectInfo: {
        schemaName: string;
        tableName: string;
        columnName?: string;
        fkName?: string;
    }, comment: SqlObjectJsonComment): string;
    private getSqlToRenameForeignKey;
    private getSqlToCreateForeignKey;
    private getSqlToCreateForeignKeys;
    private createTableIndexes;
    private getSqlToCreateIndexFunctions;
    /**
     * Returns the SQL statement that must be executed to add a column
     */
    private getSqlToAddColumn;
    private computeDeferredDefaultSql;
    /**
     * Returns the SQL statement that must be executed to alter a column
     */
    private getSqlToAlterColumn;
    /**
     * Returns the SQL query to execute to update a set of columns
     */
    private getSqlToAlterColumns;
    private getSqlToDropColumns;
    private getSqlToDropForeignKey;
    private getSqlToCreateIndex;
    private getSqlToDropIndex;
}
//# sourceMappingURL=modify-table-sql-context.d.ts.map