/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Table=exports.TestStatus=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),lodash=require("lodash"),__1=require(".."),properties_1=require("../../properties"),core_hooks_1=require("../../runtime/core-hooks"),loggers_1=require("../../runtime/loggers"),system_properties_1=require("../../runtime/system-properties"),types_1=require("../../types"),sql_delete_1=require("../mapper/sql-delete"),sql_insert_1=require("../mapper/sql-insert"),sql_update_1=require("../mapper/sql-update"),modify_table_sql_context_1=require("../sql-context/modify-table-sql-context"),read_table_sql_context_1=require("../sql-context/read-table-sql-context"),schema_sql_context_1=require("../sql-context/schema-sql-context"),sql_context_1=require("../sql-context/sql-context"),triggers_1=require("../statements/triggers"),set_sync_tick_trigger_builder_1=require("../statements/triggers/set-sync-tick-trigger-builder"),sqlLogger=loggers_1.loggers.sql;var TestStatus;!function(e){e[e.loaded=0]="loaded",e[e.modified=1]="modified"}(TestStatus||(exports.TestStatus=TestStatus={}));class Table{constructor(e){if(this.foreignKeys=[],this.factory=e.factory,this.columns=[...e.columns],!this.factory.isSharedByAllTenants)this.columns.push(system_properties_1.SystemProperties.tenantIdColumn(this.factory));this.foreignKeys=e.foreignKeys,this.columnsByPropertyName=this.columns.reduce((e,t)=>(e[t.propertyName]=t,e),{}),this.columnsByColumnName=this.columns.reduce((e,t)=>(e[t.columnName]=t,e),{}),this.isSharedByAllTenants=!!e.factory.isSharedByAllTenants,this.testStatus=TestStatus.modified}get name(){return this.factory.tableName}get sqlTableName(){return this.name}getFullTableName(e,t){return sql_context_1.SqlContext.getFullTableName(e.schemaName,this.sqlTableName,t||"")}get baseTable(){return this.factory.baseFactory?.table}get rootTable(){return this.factory.rootFactory.table}#e;get primaryKey(){if(this.#e)return this.#e;if("sys_custom_record"===this.sqlTableName)this.#e={columns:["_tenant_id","factory_name","_id"]};else if(this.isSharedByAllTenants)this.#e={columns:["_id"]};else this.#e={columns:["_tenant_id","_id"]};return this.#e}#t;get uniqueIndexes(){if(this.#t)return this.#t;return this.factory.indexes.filter(e=>e.isUnique&&"_id"!==Object.keys(e.orderBy)[0]).map(e=>({columns:[...this.factory.isSharedByAllTenants?[]:["_tenant_id"],...Object.keys(e.orderBy).map(e=>this.getSqlColumnByPropertyName(e).columnName)]}))}get databaseComputedColumnNames(){const e=this.baseTable?[]:(0,system_properties_1.databaseComputedColumnNames)(this.isSharedByAllTenants);return this.factory.nodeDecorator.isSynchronizable?[...e,"_sync_tick"]:e}getColumns(e={}){return[...this.columns,...e.inherit&&this.baseTable?this.baseTable.getColumns(e):[],...e.inherit&&this.factory.isAbstract&&!this.baseTable?[system_properties_1.SystemProperties.constructorColumn(this.factory)]:[]].filter((t,s,r)=>{if(!e.includeSystemColumns&&t.isSystem)return false;if(e.skipLazyLoadableColumns&&t.shouldLazyLoad)return false;if(t.columnName.startsWith("_")&&r.findIndex(e=>e.columnName===t.columnName)!==s)return loggers_1.loggers.nodeFactory.debug(()=>`duplicate: ${t.property.factory.tableName}.${t.columnName} isAbstract=${this.factory.isAbstract} factory=${this.factory.name}`),false;if(!this.factory.isAbstract&&"_constructor"===t.columnName)return false;return true})}getJsonComment(){const e={isSharedByAllTenants:this.factory.isSharedByAllTenants,baseTable:this.baseTable?.name};if(this.name!==this.rootTable?.name)e.rootTable=this.rootTable?.name;if(this.factory.isSetupNode)e.isSetupNode=this.factory.isSetupNode;if(this.factory.naturalKey)e.naturalKey=this.factory.naturalKey;return e}getTableDefinition(e){const t=this.name,s=system_properties_1.SystemProperties.tenantIdColumn(this.factory),r=lodash.sortBy(this.columns.map(e=>this.getColumnDefinition(e)),e=>{const t=system_properties_1.orderedSystemColumns.indexOf(e.name);return t>=0?t:system_properties_1.orderedSystemColumns.indexOf("")});this.foreignKeys=this.foreignKeys||[];const a=this.foreignKeys?.map(e=>Table.getForeignKeyDefinition(e)),i=this.factory.getSelfIndexes().map(t=>this.getIndexDefinition(e.schemaName,t,s)),n={schemaName:e.schemaName,tableName:t,columns:r,indexes:i,primaryKey:this.primaryKey,foreignKeys:a,notify:this.getNotifyOptions(),isSharedByAllTenants:this.isSharedByAllTenants,baseDefinition:this.baseTable?.getTableDefinition(e),comment:this.getJsonComment()},o=[];if(!n.comment?.baseTable)if(this.factory.isSharedByAllTenants)o.push(triggers_1.insertSharedTableTriggerBuilder),o.push(triggers_1.updateSharedTableTriggerBuilder);else o.push(triggers_1.insertTableTriggerBuilder),o.push(triggers_1.updateTableTriggerBuilder);if(this.factory.hasAttachments&&!this.factory.isAbstract)o.push(triggers_1.TriggerBuilder.registerBuilder(new triggers_1.DeleteAttachmentNodeTriggerBuilder(this.factory.name,this.factory.application.getFactoryByConstructor(core_hooks_1.CoreHooks.getAttachmentManager().getAttachmentNode()).tableName||"")));if(this.factory.nodeDecorator.isSynchronizable)o.push(set_sync_tick_trigger_builder_1.setSyncTickTriggerBuilder);const l=n.notify?.event??{};if(l.created&&l.updated&&l.deleted)if(null!=core_hooks_1.CoreHooks.auditManager.auditTriggerBuilder)o.push(core_hooks_1.CoreHooks.auditManager.auditTriggerBuilder);if(n.baseDefinition)o.push(triggers_1.deleteBaseNodeTriggerBuilder);return n.triggers=o.map(e=>e.getDefinition(n)),n}getNotifyOptions(){const e=this.factory.notifies.reduce((e,t)=>(e[t]=true,e),{});return{event:e,sqlPayloadExpression:this.getSqlExpressionTemplateForPayloadValue(e)}}getSqlExpressionTemplateForPayloadValue(e){const t=["_id",...this.factory.baseFactory?[]:["_updateTick"]].map(e=>this.factory.propertiesByName[e]);return Object.keys(e).length>0?`'{' || ${t.map(e=>`'"${e.name}":' || to_json({{ROW}}.${e.columnName})`).join(" || ',' || ")} || '}'`:""}async dropTable(e,t){const s=this.name,r=new schema_sql_context_1.SchemaSqlContext(e.application);if(!t?.ifExists||await r.tableExists(s))await r.dropTable(s,{isCascade:!!t?.cascade,errorsAsWarnings:false})}async createTable(e,t){const s=t||{},r=this.baseTable;if(r)if(!await r.tableExists(e))await r.createTable(e,t);else if(!s.skipDrop&&!this.factory.isAbstract&&await this.tableExists(e))await this.delete(e,{});s.hasNotifyTriggers=this.factory.notifies.length>0;const a=this.getTableDefinition(e),i=new modify_table_sql_context_1.ModifyTableSqlContext(e.application,a);await loggers_1.loggers.sql.doAsync(async()=>{const t=(a.columns||[]).filter(e=>"enum"===e.type||"enumArray"===e.type).map(e=>e.enumDataType);if(await this.createEnumTypes(e,t),await i.createTableFromTableDefinition(s),!s.skipGrant)await i.giveUserRightsToTable(e.sqlPool.user)})}getModifyTableSqlContext(e){return new modify_table_sql_context_1.ModifyTableSqlContext(e.application,this.getTableDefinition(e))}async createTriggers(e,t){await loggers_1.loggers.sql.do(()=>this.getModifyTableSqlContext(e).createTriggers(t))}async dropTriggers(e,t){await loggers_1.loggers.sql.do(()=>this.getModifyTableSqlContext(e).dropTriggers(t))}async ensureTableExists(e,t){if(!await this.tableExists(e))loggers_1.loggers.runtime.info(`Creating table '${this.name}'`),await this.createTable(e,t)}async ensureAllTableColumnsExists(e){const t=await new read_table_sql_context_1.ReadTableSqlContext(e.application).readSchema(this.name,{skipForeignKeys:true,skipIndexes:true,skipSecurity:true,skipSequences:true}),s=this.columns.filter(e=>!t.columns?.find(t=>t.name===e.columnName));if(s.length>0)await this.addColumns(e,s.map(e=>this.getColumnDefinition(e)))}getColumnDefinition(e){const t=e.property.dataType,s=e.getColumnType(),r=e.property instanceof properties_1.ReferenceProperty&&e.property.isSelfReference&&null==this.factory.naturalKey,a={name:e.columnName,maxLength:t instanceof types_1.StringDataType?t.maxLength:void 0,type:s,isNullable:e.isNullable,isAutoIncrement:e.isAutoIncrement,isSystem:e.isSystem,isEncryptedString:e.isEncryptedString,isSelfReference:r,comment:e.getJsonComment(),default:e.default};if(t instanceof types_1.DecimalDataType)a.precision=t.precision||10,a.scale=t.scale?t.scale:0;if(t instanceof types_1.EnumDataType){const e=t;a.enumDataType=e.getEnumType()}return a}static getForeignKeyDefinition(e){return{name:e.name,targetTable:lodash.snakeCase(e.targetTable),columnNames:e.columnNames,targetColumnNames:e.targetColumnNames,onDeleteBehaviour:e.onDeleteBehaviour,comment:e.getJsonComment(),isDeferrable:e.isDeferrable}}getIndexDefinition(e,t,s){const r=Object.keys(t.orderBy).map(r=>{const a=this.columnsByPropertyName[r],i={name:r===s.propertyName?s.columnName:a.columnName,ascending:1===t.orderBy[r]};if(t.isUnique&&a.property.isNullable)Table.setCoalesceExpressionForNullableInUniqueIndex(e,i,a.property);return i});if(!this.factory.isSharedByAllTenants&&!r.map(e=>e.name).includes(s.columnName))r.unshift({name:s.columnName,ascending:true});return{name:t.name,isUnique:!!t.isUnique,columns:r}}static setCoalesceExpressionForNullableInUniqueIndex(e,t,s){const r=t.name;if(s.isEnumProperty()){const a=s.dataType.getEnumType().name;return void(t.expression=`${e}.${a}_coalesce(${sql_context_1.SqlContext.escape(r)})`)}let a;if(s.isReferenceProperty())a="(0)::bigint";else switch(s.type){case"integer":a="(- ((2)::bigint ^ (62)::bigint))::bigint";break;case"date":a="'0001-01-01'::date";break;default:throw new Error(`unsupported property type ${s.type} for coalesce expression`)}if(a)t.expression=`COALESCE(${sql_context_1.SqlContext.escape(r)}, ${a})`}tableIsDirty(){return this.testStatus===TestStatus.modified}async createIndex(e,t){await this.getModifyTableSqlContext(e).createIndex(t)}async dropIndex(e,t){await this.getModifyTableSqlContext(e).dropIndex(t)}async addColumns(e,t,s){if(0===t.length)return;await sqlLogger.do(()=>this.getModifyTableSqlContext(e).addColumns(t,s))}async alterColumns(e,t){if(0===t.length)return;await sqlLogger.do(()=>this.getModifyTableSqlContext(e).alterColumns(t))}async dropColumns(e,t){await sqlLogger.do(()=>this.getModifyTableSqlContext(e).dropColumns(t))}async getMatchingForeignKeyDefinition(e,t,s){const r=s||await new read_table_sql_context_1.ReadTableSqlContext(e.application).readSchema(this.name,{skipColumns:true,skipIndexes:true,skipSecurity:true,skipSequences:true}),fkMatchesColumns=e=>lodash.isEqual(e.columnNames,t.columnNames),a=r.foreignKeys?.find(e=>e.name===t.name);if(a&&fkMatchesColumns(a))return a;return r.foreignKeys.find(e=>fkMatchesColumns(e))}async dropForeignKey(e,t){if(this.baseTable)await this.baseTable.dropForeignKey(e,t);await sqlLogger.do(async()=>{await this.getModifyTableSqlContext(e).dropForeignKey(t);const s=this.foreignKeys.map(e=>e.name).indexOf(t);if(s>=0)this.foreignKeys.splice(s,1)})}async renameForeignKey(e,t,s){await sqlLogger.do(()=>this.getModifyTableSqlContext(e).renameForeignKey(t,s))}async fixForeignKeys(e,t,s){const r={createdFks:0,recreatedFks:0,renamedFks:0};if(this.baseTable&&!s?.skipBaseTable){const t=await new read_table_sql_context_1.ReadTableSqlContext(e.application).readSchema(this.baseTable.name,{skipColumns:true,skipIndexes:true,skipSecurity:true,skipSequences:true}),a=await this.baseTable.fixForeignKeys(e,t,s);r.createdFks+=a.createdFks,r.recreatedFks+=a.recreatedFks,r.renamedFks+=a.renamedFks}if(!t.foreignKeys)return sqlLogger.warn(`fixForeignKeys was invoked on table ${this.name} with a current schema with no FKs`),r;return await(0,xtrem_async_helper_1.asyncArray)(this.factory.getForeignKeys()).forEach(async a=>{let i=!!s.skipExists;if(!i){const n=await this.getMatchingForeignKeyDefinition(e,a,t);let o=false;if(!n){if(i=!s.dontCreateMissingFks,i)sqlLogger.info(`Table ${this.name} - missing FK ${a.name} will be created`),r.createdFks+=1}else if(n.targetTable!==a.targetTable)sqlLogger.info(`Table ${this.name} - FK ${n.name} will be recreated (wrong target table: ${n.targetTable} -> ${a.targetTable})`),r.recreatedFks+=1,o=true;else if(n.onDeleteBehaviour!==a.onDeleteBehaviour)sqlLogger.info(`Table ${this.name} - FK ${n.name} will be recreated (wrong delete behaviour: ${n.onDeleteBehaviour} -> ${a.onDeleteBehaviour})`),r.recreatedFks+=1,o=true;else if(n.isDeferrable!==a.isDeferrable)sqlLogger.info(`Table ${this.name} - FK ${n.name} will be recreated (isDeferrable mismatch: ${n.isDeferrable} -> ${a.isDeferrable})`),r.recreatedFks+=1,o=true;else if(n.name!==a.name)await this.renameForeignKey(e,n.name,a.name),r.renamedFks+=1,sqlLogger.info(`Table ${this.name} - FK ${n.name} was renamed to ${a.name})`);if(o){if(!n)throw new Error(`Logic error: the FK to re-create does not exist (${a.name})`);await this.dropForeignKey(e,n.name),i=true}}if(!i)return;await this.addForeignKey(e,a)}),r}async addForeignKey(e,t,s,r){if(!r?.skipExists&&await this.getMatchingForeignKeyDefinition(e,t,s))return;const a=Table.getForeignKeyDefinition(t);if(await sqlLogger.do(()=>this.getModifyTableSqlContext(e).addForeignKey(a,r)),this.foreignKeys=this.foreignKeys||[],!this.foreignKeys.some(e=>e.name===t.name&&e.targetTable===t.targetTable))this.foreignKeys.push(t);if(s)s.foreignKeys=s.foreignKeys||[],s.foreignKeys.push(a)}getForeignKeyByName(e){return this.foreignKeys.find(t=>t.name===e)}async dropAllForeignKeys(e){const t=await new read_table_sql_context_1.ReadTableSqlContext(e.application).readSchema(this.name,{skipColumns:true,skipIndexes:true,skipSecurity:true,skipSequences:true});await(0,xtrem_async_helper_1.asyncArray)(t.foreignKeys||[]).forEach(t=>this.dropForeignKey(e,t.name))}tableExists(e){return new schema_sql_context_1.SchemaSqlContext(e.application).tableExists(this.name)}async createEnumTypes(e,t){if(t.length>0)await new __1.EnumSqlContext(e.application).createEnumTypes(t)}getColumnValues(e){return lodash.pick(e,Object.keys(this.columnsByPropertyName))}getSqlColumnByPropertyName(e){return this.columnsByPropertyName[e]}getSqlColumnNameByPropertyName(e){return this.getSqlColumnByPropertyName(e).columnName}getSqlColumnByColumnName(e){return this.columnsByColumnName[e]}getSqlColumnNameByColumnName(e){return this.getSqlColumnByColumnName(e).columnName}insert(e,t,s={}){return new sql_insert_1.SqlInsert(this).insert(e,t,s)}insertFromSqlFile(e,t,s={}){return new sql_insert_1.SqlInsert(this).insertFromSqlFile(e,t,s)}static dropUpsertSqlFunction(e){return sql_insert_1.SqlInsert.dropUpsertSqlFunction(e)}update(e,t,s={}){return new sql_update_1.SqlUpdate(this).update(e,t,s)}delete(e,t){return new sql_delete_1.SqlDelete(this).delete(e,t)}findColumnByPropertyName(e){const t=this.columnsByPropertyName[e];if(t)return t;if(this.baseTable)return this.baseTable.findColumnByPropertyName(e);throw this.tableError(`invalid property name: ${e}`)}findColumnByColumnName(e){const t=this.columns.find(t=>t.columnName===e);if(!t)throw this.tableError(`invalid column name: ${e}`);return t}tableError(e){return new Error(`table ${this.name}: ${e}`)}markAsLoadedForTests(e,t){this.testStatus=TestStatus.loaded,this.testLayers=[...t.testLayers],sqlLogger.debug(()=>`markAsLoadedForTests(${this.name}) this.testLayers:${JSON.stringify(this.testLayers)}`),this.testNowMock=t.testNowMock,this.testDir=e.dir}markAsModifiedForTests(){this.testStatus=TestStatus.modified}async fixAutoIncrementSequences(e){sqlLogger.verbose(()=>`Table ${this.name}: fixing auto-increment sequences`);const t=await this.factory.application.createContextForDdl(e=>this.getTableDefinition(e),{description:()=>`Get table definition ${this.name}`});await new __1.SequenceSqlContext(this.factory.application,t.tableName).fixAutoIncrementSequences(e,t.columns?.filter(e=>e.isAutoIncrement).map(e=>e.name)||[])}}exports.Table=Table;
//# sourceMappingURL=table.js.map