/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.NotificationSubscriptionManager=void 0;const xtrem_log_1=require("@sage/xtrem-log"),pg_listen_1=require("pg-listen"),container_manager_1=require("../../runtime/container-manager"),logger=new xtrem_log_1.Logger(__filename,"pubsub");class NotificationSubscriptionManager{static async createPostgresSubscriber(r){const e=(0,pg_listen_1.default)({host:r.hostname,user:r.user,password:r.password,database:r.database,port:r.port},{...r?.subscriber});await e.connect();const s=container_manager_1.ContainerManager.containerId;return logger.info(`Subscriber session connected ${s}`),e.events.on("error",r=>{logger.error(()=>`Subscriber error: ${r.stack}`),process.exit(1)}),process.on("exit",()=>{logger.info(()=>`Closing subscriber session ${s}`),this.closeSubscriber()}),e}static async getSubscriber(r){if(!this.subscriber){const e={...r.sql};if(!e)throw new Error("cannot get SQL pool: missing 'sql' configuration");this.subscriber=await this.createPostgresSubscriber(e)}return this.subscriber}static closeSubscriber(){(async()=>{if(!this.subscriber)return;await this.subscriber.close(),logger.info(`Subscriber session closed ${container_manager_1.ContainerManager.containerId}`),this.subscriber=void 0})().catch(r=>logger.error(r))}}exports.NotificationSubscriptionManager=NotificationSubscriptionManager;
//# sourceMappingURL=subscriber.js.map