import { AnyRecord, AsyncResponse } from '@sage/xtrem-async-helper';
import { Context } from '../../runtime/context';
export interface PublishOptions {
    excludeSelf?: boolean;
}
export type PubSubPayload = AnyRecord & {
    tenantId: string | null;
};
export interface PubSubEnvelope {
    data: string;
    containerId: string;
    excludeSelf: boolean;
}
/**
 * Static class to support pubsub of topics with postgres NOTIFY / LISTEN.
 * This mechanism is used by the framework to synchronize operations across containers.
 * This API is reserved to system components. Applicative modules should not use it.
 */
export declare abstract class PubSub {
    /**
     * Gets the channel name based on the topic
     */
    static getChannelName(topic: string): string;
    /**
     * Publish notification for topic, if this is a broadcast we need to use a prefix on channel name
     */
    static publish(context: Context, topic: string, data: PubSubPayload, options?: PublishOptions): Promise<void>;
    /**
     * Subscribe to a topic
     */
    static subscribe(topic: string, listener: (data: PubSubPayload, containerId?: string) => AsyncResponse<void>): Promise<void>;
    /**
     * Returns whether topic has been subscribed or not
     */
    static isSubscribed(topic: string): Promise<boolean>;
    /**
     * Unsubscribe from notifications on channel
     */
    private static unsubscribeChannel;
    /**
     * Unsubscribe from notifications on topic
     */
    static unsubscribe(topic: string): Promise<void>;
    /**
     * Unsubscribe from all channels
     */
    static unsubscribeAll(): Promise<void>;
}
//# sourceMappingURL=pubsub.d.ts.map