/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ContainerHeartbeatMonitor=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_log_1=require("@sage/xtrem-log"),container_manager_1=require("../../runtime/container-manager"),pubsub_1=require("./pubsub"),logger=xtrem_log_1.Logger.getLogger(__filename,"heartbeat");class ContainerHeartbeatMonitor{static{this._isActive=false}static{this._isPublishing=false}static{this._topic="containers-heartbeats"}static{this._containers={}}static get heartbeatMillis(){return 1e3*(xtrem_config_1.ConfigManager.current.interop?.heartbeatSeconds??1)}static get aliveContainers(){return Object.keys(ContainerHeartbeatMonitor._containers)}static _containerHeartbeatListener(t){const e=ContainerHeartbeatMonitor._containers;if(logger.debug(()=>`Received heartbeat from container ${t.containerId}`),t.containerId!==container_manager_1.ContainerManager.containerId&&null==e[t.containerId])logger.verbose(()=>`New container ${t.containerId} has been started`);e[t.containerId]={timestamp:xtrem_date_time_1.Datetime.now(true)}}static get isActive(){return ContainerHeartbeatMonitor._isActive}static async _publishHeartbeat(t){await t.asRoot.withCommittedContext(null,async t=>{logger.debug(()=>`Container ${container_manager_1.ContainerManager.containerId}: publish heartbeat`),await pubsub_1.PubSub.publish(t,ContainerHeartbeatMonitor._topic,{tenantId:null,containerId:container_manager_1.ContainerManager.containerId},{excludeSelf:true})},{description:()=>"Publish heartbeat"});const e=ContainerHeartbeatMonitor._containers,a=xtrem_date_time_1.Datetime.now(true).value;Object.keys(e).forEach(t=>{if(a-e[t].timestamp.value>3*ContainerHeartbeatMonitor.heartbeatMillis)delete e[t],logger.info(`Container ${t} is dead`)})}static async activateHeartbeatPublications(t){if(0===ContainerHeartbeatMonitor.heartbeatMillis)return;if(xtrem_config_1.ConfigManager.current.storage?.managedExternal)throw new Error("Hearbeat monitor not supported in this context");if(ContainerHeartbeatMonitor._isPublishing)return;ContainerHeartbeatMonitor._isPublishing=true,logger.info(`Publication of heartbeats started on container ${container_manager_1.ContainerManager.containerId}`),await ContainerHeartbeatMonitor._publishHeartbeat(t),setInterval(()=>{ContainerHeartbeatMonitor._publishHeartbeat(t).catch(t=>logger.error(t))},ContainerHeartbeatMonitor.heartbeatMillis)}static async activate(){if(xtrem_config_1.ConfigManager.current.storage?.managedExternal)throw new Error("Hearbeat monitor not supported in this context");if(ContainerHeartbeatMonitor._isActive)return;ContainerHeartbeatMonitor._isActive=true,logger.info(`Monitor activated on container ${container_manager_1.ContainerManager.containerId}`),await pubsub_1.PubSub.subscribe(ContainerHeartbeatMonitor._topic,ContainerHeartbeatMonitor._containerHeartbeatListener)}}exports.ContainerHeartbeatMonitor=ContainerHeartbeatMonitor;
//# sourceMappingURL=container-heartbeat-monitor.js.map