/**
 * This class handles broadcasts
 */
import { Application } from '../../application';
import { PubSubPayload } from './pubsub';
export type BroadcastPayload = PubSubPayload & {
    $broadcastId: string;
    $fromContainerId: string;
};
export declare abstract class BroadcastHandler {
    private static _makeAckTopic;
    /**
     *
     * Broadcast a message and wait_ for an acknowledgement from all the alive containers
     * @param payload
     */
    static broadcast(application: Application, topic: string, payload: PubSubPayload, options?: {
        timeout?: number;
    }): Promise<void>;
    /**
     * Send the acknowledgement for a received broadcast
     */
    static acknowledge(application: Application, topic: string, payload: BroadcastPayload): Promise<void>;
    /**
     * Send an error as acknowledgement for a received broadcast
     */
    static acknowledgeWithError(application: Application, topic: string, payload: BroadcastPayload, error: string): Promise<void>;
}
//# sourceMappingURL=broadcast-handler.d.ts.map