/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlUpdate=void 0;const lodash=require("lodash"),custom_metrics_1=require("../../metrics/prometheus/custom-metrics"),utils_1=require("../../runtime/utils"),sql_context_1=require("../sql-context/sql-context"),sql_converter_1=require("./sql-converter"),sql_util_1=require("./sql-util");class SqlUpdate{constructor(e){this.table=e}get factory(){return this.table.factory}getUpdateParameters(e,t,r){const{context:s}=e,a=r.onlyColumns,l=this.table.columns.filter(e=>{if(a?.[e.columnName])return true;return!(a||e.isSystem&&"_custom_data"!==e.columnName&&"_sync_info"!==e.columnName)}),o=[],i=[];return l.filter(e=>"_id"!==e.propertyName&&"_constructor"!==e.propertyName).filter(e=>!t._vendor||t._vendor&&(r.updateFromCsv||e.property.isOwnedByCustomer)).forEach(r=>{if(r.property.isLocalized)sql_util_1.SqlUtil.setLocalizedValue(s,t,r.property.name,"update");sql_util_1.SqlUtil.pushValuesForUpdateOrInsert(this.table,e,r,t[r.propertyName],o,i)}),{columnNames:o,valsOrParameters:i}}getForWhereParameters(e,t){const r=[],s=[];return sql_util_1.SqlUtil.pushValuesForUpdateOrInsert(this.table,e,this.table.columnsByPropertyName._id,t._id,r,s),{columnsForWhere:r,valsForWhere:s}}async update(e,t,r={}){try{const s={...t};let a=[];const l=new sql_converter_1.SqlConverter(e,this.factory);if(this.table.baseTable)a=await new SqlUpdate(this.table.baseTable).update(e,s,r);const{columnNames:o,valsOrParameters:i}=this.getUpdateParameters(l,s,r);if(!o.length){if(!this.table.factory.isAbstract||this.table.factory.baseFactory)return a;o.push("_id"),i.push(String(s._id))}const{columnsForWhere:n,valsForWhere:c}=r.ignoreAllSystemFilters?{columnsForWhere:[],valsForWhere:[]}:this.getForWhereParameters(l,s);let u=[];if(!e.processLocalizedTextAsJson)u=this.table.columns.filter(e=>e.property.isLocalized&&o.includes(sql_context_1.SqlContext.escape(e.columnName))).map(e=>sql_context_1.SqlContext.escape(e.columnName));const m=["_id",...this.table.databaseComputedColumnNames],d=o.map((e,t)=>{if(u.includes(e))return`${e}=${e} || ${i[t]}`;if("_custom_data"===e)return m.push("_custom_data"),`${e}=COALESCE(${e} || ${i[t]}, ${i[t]})`;return`${e}=${i[t]}`}).join(","),p=n.map((e,t)=>`${e}=${c[t]}`);if(r.filter)p.push(l.convertWhere(r.filter));if(e.processLocalizedTextAsJson)m.push(...this.table.columns.filter(e=>e.property.isLocalized&&o.includes(sql_context_1.SqlContext.escape(e.columnName))).map(e=>sql_context_1.SqlContext.escape(e.columnName)));const _=`UPDATE ${this.table.getFullTableName(e)}\nSET ${d}\nWHERE ${(0,utils_1.tenantCondition)(l,this.table,"",p)}\nRETURNING ${lodash.uniq(m).join(",")}`,h=await sql_converter_1.SqlConverter.getParameterValues(e,l.sqlParameters,{values:s,where:r.filter}),q=await custom_metrics_1.CustomMetrics.sql.withMetrics({nodeName:this.factory.name,statementKind:"update"},()=>e.executeSql(_,h));if(q.length>0)sql_context_1.SqlContext.logger.verbose(()=>`Returning values: ${JSON.stringify(q)}`);if(e.testMode)this.table.markAsModifiedForTests();if(q&&a.length)return q.map(e=>({...e,...a.find(t=>t._id===e._id)||{}}));return q||[]}catch(t){if(e.testMode)this.table.markAsModifiedForTests();throw t}}}exports.SqlUpdate=SqlUpdate;
//# sourceMappingURL=sql-update.js.map