/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlResolver=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),lodash_1=require("lodash"),loggers_1=require("../../runtime/loggers"),system_properties_1=require("../../runtime/system-properties"),naming_1=require("../statements/naming"),logger=loggers_1.loggers.sql;class SqlResolver{static checkDateOrDatetimeType(e,r){if(!e)throw new Error(`Type not defined for '${r}'`);if("date"!==e&&"datetime"!==e&&"dateRange"!==e&&"datetimeRange"!==e)throw new Error(`Only date/datetime/dateRange properties can be grouped by '${r}`)}static{this.dateAggregateFormats={day:"YYYY-MM-DD",month:"YYYY-MM-01",year:"YYYY-01-01"}}static castIfBoolean(e,r){return"boolean"===r?`(CAST(${e} as INTEGER))`:e}static aggregateSql(e,r,t){switch(t){case"min":case"max":if("boolean"===r.type)return`${t}(CAST(${r.sql} as INTEGER))::BOOLEAN`;return`${t.toUpperCase()}(${r.sql})`;case"sum":case"avg":{const e=`${t.toUpperCase()}(${r.sql})`;if("short"===r.type||"integer"===r.type)return`${e}::FLOAT8`;return e}case"value":return r.sql;case"year":case"month":case"day":return SqlResolver.checkDateOrDatetimeType(r.type,t),`TO_CHAR(${r.sql}, ${e.resolveLiteral(SqlResolver.dateAggregateFormats[t])})::DATE`;case"distinctCount":return`COUNT(DISTINCT ${SqlResolver.castIfBoolean(r.sql,r.type)})`;case"hasNull":return`BOOL_OR(${SqlResolver.castIfBoolean(r.sql,r.type)} IS NULL)`;default:throw new xtrem_shared_1.LogicError(`invalid aggregate operator: ${t}`)}}static castFromJson(e,r){switch(r){case"short":case"integer":case"reference":return`(${e}->>0)::INT8`;case"float":case"double":return`(${e}->>0)::FLOAT8`;case"decimal":return`(${e}->>0)::NUMERIC`;case"string":case"enum":return`(${e}->>0)::TEXT`;case"date":return`(${e}->>0)::DATE`;default:return e}}static getNumericAggregateValueType(e,r){switch(e){case"short":case"integer":return"sum"===r?"integer":"double";case"float":case"double":return"double";case"decimal":return"decimal";default:throw new xtrem_shared_1.LogicError(`invalid type for ${r} operator: ${e}`)}}static getAggregateValueType(e,r){switch(r){case"min":case"max":case"year":case"month":case"day":case"value":return e;case"sum":case"avg":return SqlResolver.getNumericAggregateValueType(e,r);case"distinctCount":return"integer";case"hasNull":return"boolean";default:throw new xtrem_shared_1.LogicError(`invalid aggregate operator: ${r}`)}}static resolveAggregate(e,r,t){if(!t)throw new xtrem_shared_1.LogicError(`${r.path}: missing aggregate name`);const a=r.type??r.property?.type;if(!a)throw new xtrem_shared_1.LogicError(`${r.path}: missing type`);return{...r,aggregationOperator:t,type:SqlResolver.getAggregateValueType(a,t),sql:SqlResolver.aggregateSql(e,r,t),columnAlias:SqlResolver.makeColumnAlias(`${r.columnAlias}_${t}`)}}static makeColumnAlias(e){return(0,naming_1.makeName63)(e.replaceAll("__","._").split("._").map(e=>(0,lodash_1.snakeCase)(e)).join("__"))}static resolveCustomData(e,r,t){const a=e.context.customFields[r.factory.name].find(e=>e.name===t),s=a?.dataType;if(!a)throw r.factory.logicError(`custom field ${t} not found`);const o=this.castFromJson(`${r.sql}->${e.resolveLiteral(t)}`,s);return{...r,type:s,sql:o,columnAlias:this.makeColumnAlias(o)}}static resolveJson(e,r,t){if("_customData"===r.property?.name&&e.context.customFields[r.factory.name])return this.resolveCustomData(e,r,t);const a=`${r.sql}->${e.resolveLiteral(t)}`;return{...r,type:"json",sql:a,columnAlias:this.makeColumnAlias(a)}}static resolveDate(e,r,t){const a=e.convertDatePropertyResult(r,t);return{...a,columnAlias:this.makeColumnAlias(a.sql)}}static resolveRange(e,r,t){let a;switch(r){case"start":a=`lower(${e.sql})`;break;case"end":a=`upper(${e.sql})`;break;default:throw new xtrem_shared_1.LogicError(`${e.path}.${r}: invalid range property`)}return{...e,property:void 0,type:t.replace(/Range$/,""),sql:a,columnAlias:this.makeColumnAlias(a)}}static resolveArray(e,r){return{...e,type:r}}static resolveTextStream(e){return e}static resolve(e,r,t,a,s){if("jsonReference"===t.type)return SqlResolver.resolveJson(e,t,a);if("json"===t.property?.type)return SqlResolver.resolveJson(e,t,a);if("date"===t.property?.type)return SqlResolver.resolveDate(e,t,a);if("dateRange"===t.property?.type)return SqlResolver.resolveRange(t,a,"date");if("datetimeRange"===t.property?.type)return SqlResolver.resolveRange(t,a,"datetime");if("integerRange"===t.property?.type)return SqlResolver.resolveRange(t,a,"integer");if("decimalRange"===t.property?.type)return SqlResolver.resolveRange(t,a,"decimal");if("integerArray"===t.property?.type)return SqlResolver.resolveArray(t,"integer");if("enumArray"===t.property?.type)return SqlResolver.resolveArray(t,"integer");if("stringArray"===t.property?.type)return SqlResolver.resolveArray(t,"string");if("textStream"===t.property?.type)return SqlResolver.resolveTextStream(t);const o=t.factory;if(!o)throw new Error("internal error: no factory");let l;if("_constructor"===a)l=system_properties_1.SystemProperties.constructorProperty(s),l.isInherited=!!o.baseFactory;else if("_updateTick"===a)l=system_properties_1.SystemProperties.updateTickProperty(o);if(!l)l=o.findProperty(a);if(l.delegatesTo)return e.convertDelegatesTo(t,l);const n=t.path?`${t.path}.${a}`:a;if(r.collectedDependencyPaths)if(!r.collectedDependencyPaths.includes(n))r.collectedDependencyPaths.push(n);let i="",c="";if(!l.isStored){if(l.getValue){const r=l.getValue;try{i=e.withThisResultScope(t,()=>e.convertFunction(r)).sql,c=SqlResolver.makeColumnAlias(n)}catch(e){throw logger.error(e.message),l.systemError(`cannot convert 'getValue' function to SQL: ${e.message}`)}}else if(l.computeValue)throw l.systemError("property cannot by converted to SQL because it is defined by a 'computeValue' rule")}else{const a=`${t.alias}.${l.columnName}`;if(i=a,l?.isLocalized)if(r.processLocalizedTextAsJson)i=`${a}#>>${e.resolveLiteral("{}")}`;else{const{collation:t}=r,s=t?` COLLATE "${t}"`:"";i=`coalesce(${[...r.locales,"base"].map(r=>`${a}->>${e.resolveLiteral(r)}`).join(", ")})${s}`}c=SqlResolver.makeColumnAlias(a)}const p=l.isNullable||"reference"===t.property?.type&&t.property?.isNullable,u={alias:t.alias,path:n,type:l.type,isNullable:p,isInherited:l.isInherited&&l.isStored,property:l,factory:l.isForeignNodeProperty()?l.targetFactory:o,sql:i,columnAlias:c};if(l.isForeignNodeProperty()){if(u.factory=l.targetFactory,l.isCollectionProperty()||l.isVital)u.reverseReferenceName=l.reverseReference;if(l.isReferenceProperty()&&l.isVital)u.parent=t,u.path=`${t.path}.${l.name}`,e.makeAliasAndJoin(u),u.sql=`${u.alias}._id`}return u}}exports.SqlResolver=SqlResolver;
//# sourceMappingURL=sql-resolver.js.map