import { FactoryMetadata } from '../../types/sql-file-data';
import { SqlParameter } from './sql-converter';
/**
 * table.insert options
 */
export interface SqlInsertOptions {
    /**
     * Options constructor name - used by subclassing
     */
    constructorName?: string;
    /**
     * Try update if insert fails because of conflict on primary key
     */
    useUpsert?: boolean;
    /**
     * When useUpsert is true: columns that upsert should not update (flagged with isOwnedByCustomer)
     */
    upsertColumnsToIgnore?: string[];
    /**
     * Option to execute insert with ON CONFLICT DO NOTHING
     * This will override useUpsert flag
     */
    onConflictDoNothing?: boolean;
    /**
     * When upsert is true: should errors on upsert (mainly unique index violation) be ignored ?
     */
    ignoreUpsertErrors?: boolean;
    /**
     * Specific metadata to use to insert the value (when not set, it will be extracted from the current table definition)
     */
    metadata?: FactoryMetadata;
    /**
     * insert values in audit columns (_create_user, _create_stamp, _update_user, _update_stamp, _update_tick)
     * instead of letting the database triggers compute them.
     */
    preserveAuditColumns?: boolean;
}
/**
 * Structure of a cache entry for a generated INSERT statement
 *
 * This structure should be kept reasonably small.
 * It may reference metadata objects (Property instances) because this only costs a pointer
 * but it should not duplicate metadata.
 */
export interface CachedInsert {
    sql: string;
    sqlParameters: SqlParameter[];
    upsertFunctionSql: string;
}
//# sourceMappingURL=sql-insert.d.ts.map